# Contribute to QloApps

QloApps is an open-source software and we all know that community contributions lie at the heart of any open-source software. It is the essence of an open-source that a diverse group of individuals collaborate and innovate the best possible solutions.

Here are the ways you can contribute to the QloApps project.

## Code Enhancements

As a PHP developer, if you have command on not only PHP but also MySQL and also know how to use Git and GitHub efficiently you can contribute to code enhancements via [pull requests on GitHub](https://github.com/webkul/hotelcommerce/pulls).

### Current Feature Enhancement

If you feel there is a scope for improvement in any current feature of the system then just send us the pull request with your enhanced codes. The team will review it and if everything is up to the mark then it will be merged with the main branch.

In QloApps we follow a modular approach to bring functionalities into the system. The system has its native modules for different features.

You can also improve these modules besides the core features to improve the features of the system.

### Addition Of A New Feature

Any system can never have all the features that satisfy the needs of every business out there. And we all have different mindsets.
So you can always think of a feature that is not there in the system.

Again we will need your pull requests on GitHub. And if everything is fine we will merge your request into the main branch.

### Bug Fixing

The beauty of being an open-source software is that anyone who knows to code can improve your code.

We always try that keep the system as bug-free as we can. But still, if there is anything left and you have resolved it then send it to us.

You have to follow the GitHub PR system for bug fixings also.

### Optimization

If you have an idea to make the system more optimized and you can make the system work better then it's time to make a pull request at the [QloApps Github repository](https://github.com/webkul/hotelcommerce).

The better-written code the better the software performance.

### Report Security Issues

QloApps values the contributions of the security research community, and we look forward to working with you to minimize risk to QloApps users.

If you have found a security issue in QloApps, please do not use the issue tracker and don't publish it publicly. Instead, report the security issue to [support@qloapps.com](mailto:support@qloapps.com) or contact [QloApps Support](https://webkul.uvdesk.com/en/customer/create-ticket/). So that we can act on it immediately to avoid as much damage as we can.


## Testing

### Bug Reporting

Bugless development is impossible, we can just try to leave as minimum bugs in the system as we can. At QloApps also we try our best to make the system free of bugs.

Every release goes through a process of quality analysis before reaching you. But as we know it is a huge software with a lot of code files, so there is a possibility that there is any bug left.

So we need you to report any bug you find in the system to our QA Team. Our team will check the bug and find the best possible solution to resolve it.

You can report a bug either on our GitHub [Issues](https://github.com/webkul/hotelcommerce/issues) or on our [Forum](http://forums.qloapps.com/).
