<?php 
namespace Opencart\Admin\Controller\Extension\SoTheme\Module;
class YT_Shortcode_pricing_tables_config {
	static function get_config($language,$value) {
		$multiLanguage = explode(',',$value['language']);
		$name_shortcode_arr = array();
		$name_shortcode = (is_array($value) && isset($value[0]['name_shortcode']) ? $value[0]['name_shortcode'] : $language->get('shortcode_pricing_table'));
		foreach($multiLanguage as $language_)
		{
			$name_shortcode_arr['name_shortcode_'.$language_] = (is_array($value) && isset($value[0]['name_shortcode_'.$language_]) ? $value[0]['name_shortcode_'.$language_] : $name_shortcode);
		}
		return array(
			'name_shortcode' => array(
				'type' 		=> 'textLanguage',
				'default' 	=> (is_array($value) && isset($value[0]['name_shortcode']) ? $value[0]['name_shortcode'] : $language->get('shortcode_pricing_table')),
				'values'  	=> $name_shortcode_arr,
				'name'    	=> $language->get('shortcode_name_shortcode'),
				'desc'    	=> $language->get('shortcode_name_shortcode_desc'),
				'child'  => array(

	            )
			),
			'name_shortcode_status' => array(
				'type' 		=> 'bool',
				'default' 	=> (is_array($value) && isset($value[0]['name_shortcode_status']) ? $value[0]['name_shortcode_status'] : 'no'),
				'name' 		=> $language->get('shortcode_name_shortcode_status'),
				'desc' 		=> $language->get('shortcode_name_shortcode_status_desc'),
			),
			'type' => array(
				'type' 		=> 'select',
				'default' 	=> (is_array($value) && isset($value[0]['type']) ? $value[0]['type'] : 'style1'),
				'values' 	=> YT_Data::type_pricing_tables($language),
				'name' 		=> $language->get('shortcode_type'),
				'desc' 		=> $language->get('shortcode_type_desc'),
				'child' => array(

				),		
			),
			'columns' => array(
				'type' 		=> 'slider',
				'default' 	=> (is_array($value) && isset($value[0]['columns']) ? $value[0]['columns'] : 3),
				'min' 		=> 1,
				'max' 		=> 5,
				'step' 		=> 1,
				'name' 		=> $language->get('shortcode_pricing_table_column'),
				'desc' 		=> $language->get('shortcode_pricing_table_column_desc'),
			),
			'yt_class'=> array(
				'default' 	=> (is_array($value) && isset($value[0]['yt_class']) ? $value[0]['yt_class'] : ''),
				'name'  	=> $language->get('shortcode_yt_class'),
				'desc'  	=> $language->get('shortcode_yt_class_desc')
			),
			'css_internal'=> array(
				'type' 		=> 'textarea',
				'default' 	=> (is_array($value) && isset($value[0]['css_internal']) ? $value[0]['css_internal'] : ''),
				'name'  	=> $language->get('shortcode_css_internal'),
				'desc'  	=> $language->get('shortcode_css_internal_desc')
			),
		);
	}
}

?>