<?php
namespace Opencart\Catalog\Controller\Localisation;
/**
 * Class Country
 *
 * @package Opencart\Catalog\Controller\Localisation
 */
class Country extends \Opencart\System\Engine\Controller {
	/**
	 * @return void
	 */
	public function index(): void {
		$json = [];
		
		if (isset($this->request->get['doctype']) && isset($this->request->get['docid'])) {
			$docid = ($this->request->get['docid']) ?: 0;

			switch ($this->request->get['doctype']) {
				case 'getCities':
					$sql = "SELECT * FROM " . DB_PREFIX . "zone_cities WHERE zone_id = " . (int)$docid . " order by name asc";
					break;
				case 'getDistrict':
					$sql = "SELECT * FROM " . DB_PREFIX . "zone_districts WHERE city_id = " . (int)$docid . " order by name asc";
					break;
				case 'getSubDistrict':
					// $sql = "SELECT * FROM " . DB_PREFIX . "zone_subdistricts WHERE district_id = " . (int)$docid . " and coalesce(key_integration_id,0) > 0 order by name asc";
					$sql = "SELECT * FROM " . DB_PREFIX . "zone_subdistricts WHERE district_id = " . (int)$docid . " order by name asc";
					break;
				case 'getPostalCode': 
					$sql = "SELECT * FROM " . DB_PREFIX . "zone_subdistricts WHERE id = " . (int)$docid;
					break;
				default:
					$sql = '';
					break;
			}
 
			if($sql){
				$query = $this->db->query($sql); 
				$json = ['data'=> $query->rows];
			}
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}else{
			if (isset($this->request->get['country_id'])) {
				$country_id = (int)$this->request->get['country_id'];
			} else {
				$country_id = 0;
			}
	
			$this->load->model('localisation/country');
	
			$country_info = $this->model_localisation_country->getCountry($country_id);
	
			if ($country_info) {
				$this->load->model('localisation/zone');
	
				$json = [
					'country_id'        => $country_info['country_id'],
					'name'              => $country_info['name'],
					'iso_code_2'        => $country_info['iso_code_2'],
					'iso_code_3'        => $country_info['iso_code_3'],
					'address_format_id' => $country_info['address_format_id'],
					'postcode_required' => $country_info['postcode_required'],
					'zone'              => $this->model_localisation_zone->getZonesByCountryId($country_id),
					'status'            => $country_info['status']
				];
			}
	
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
		}
	}
	// public function getCustomAddress() : void
	// {
	// 	$json = [];
	// 	if (isset($this->request->get['doctype']) && isset($this->request->get['docid'])) {
	// 		$docid = ($this->request->get['docid']) ?: 0;
	// 		switch ($this->request->get['doctype']) {
	// 			case 'getCities':

	// 				$sql = "SELECT * FROM " . DB_PREFIX . "zone_cities WHERE zone_id = " . (int)$docid . " order by name asc";
	// 				break;
	// 			case 'getDistrict':
	// 				$sql = "SELECT * FROM " . DB_PREFIX . "zone_districts WHERE city_id = " . (int)$docid . " order by name asc";
	// 				break;
	// 			case 'getSubDistrict':
	// 				$sql = "SELECT * FROM " . DB_PREFIX . "zone_subdistricts WHERE district_id = " . (int)$docid . " and coalesce(key_integration_id,0) > 0 order by name asc";
	// 				break;
	// 			case 'getPostalCode': 
	// 				$sql = "SELECT * FROM " . DB_PREFIX . "zone_subdistricts WHERE id = " . (int)$docid;
	// 				break;
	// 			default:
	// 				$sql = '';
	// 				break;
	// 		}
	// 		if($sql){
	// 			$query = $this->db->query($sql); 
	// 			$json = ['data'=> $query->rows];
	// 		}
			
	// 	}
		
	// 	$this->response->addHeader('Content-Type: application/json');
	// 	$this->response->setOutput(json_encode($json));
	// }
}