<?php
namespace Opencart\Catalog\Controller\Extension\SoTheme\SimpleBlog;
require_once (DIR_EXTENSION.'so_theme/admin/view/template/soconfig/class/soconfig.php');
	class ArticleInfo extends \Opencart\System\Engine\Controller {	
		public function index() {
			$this->load->language('extension/so_theme/simple_blog/article','',$this->config->get('config_language'));
			$this->document->addStyle('extension/so_theme/catalog/view/javascript/simple_blog/css/style.css');
			//$this->document->setTitle($this->language->get('heading_title'));
			if($this->config->get('simple_blog_heading')) {
				$this->document->setTitle($this->config->get('simple_blog_heading'));
			} else {
				$this->document->setTitle($this->language->get('heading_title'));
			}
			
			$this->load->model('extension/so_theme/simple_blog/article');
			
			$this->load->model('tool/image');
			
			$this->load->model('catalog/product');
			
			if(isset($this->request->get['simple_blog_article_id'])) {
				$simple_blog_article_id = $this->request->get['simple_blog_article_id'];
			} else {
				$simple_blog_article_id = 0;
			}
			
			if ($simple_blog_article_id) {
				
				$data['simple_blog_article_id'] = $simple_blog_article_id;
				
				if($this->config->has('simple_blog_product_related_heading')) {
					$data['text_related_product'] = $this->config->get('simple_blog_product_related_heading');
				} else {
					$data['text_related_product'] = $this->language->get('text_related_product');
				}
				
				//$data['button_cart'] = $this->language->get('button_cart');
				
				if($this->config->has('simple_blog_comment_related_heading')) {
					$data['text_related_comment'] = $this->config->get('simple_blog_comment_related_heading');
				} else {
					$data['text_related_comment'] = $this->language->get('text_related_comment');
				}
				
				
				
				$data['text_write_comment'] = $this->language->get('text_write_comment');
				
				$data['text_note'] = $this->language->get('text_note');
				$data['text_wait'] = $this->language->get('text_wait');
				
				$data['entry_name'] = $this->language->get('entry_name');
				$data['entry_captcha'] = $this->language->get('entry_captcha');
				$data['entry_review'] = $this->language->get('entry_review');		
				
				$data['button_submit'] = $this->language->get('button_submit');	
				
				$data['text_no_found'] = $this->language->get('text_no_found');
							
				$article_info = $this->model_extension_so_theme_simple_blog_article->getArticle($simple_blog_article_id);
				
				if($article_info) {
					
					$this->document->setTitle($article_info['article_title']);
					$this->document->setDescription($article_info['meta_description']);
					$this->document->setKeywords($article_info['meta_keyword']);
					
					//print "<pre>"; print_r($article_info); exit;
					$data['article_info_found'] = $article_info;
					
					// here comes means customer or other viewer can see the blog so need to increment the view counter
					$this->model_extension_so_theme_simple_blog_article->addBlogView($article_info['simple_blog_article_id']);
					
					if($article_info['featured_image']) {
						$data['featured_found'] = 1;
						$data['image'] = HTTP_SERVER . 'image/' . $article_info['featured_image'];
                    } else if($article_info['image']) {
						$data['image'] = HTTP_SERVER . 'image/' . $article_info['image'];
						$featured_found = '';
                    } else {
						
						$data['image'] = $this->model_tool_image->resize('placeholder.png', 600, 390);
						$featured_found = '';
					}
					
					// author url
					$data['author_url'] = $this->url->link('extension/so_theme/simple_blog/author', 'simple_blog_author_id=' . $article_info['simple_blog_author_id'], true);
					
					// get total comments
					$total_comments = $this->model_extension_so_theme_simple_blog_article->getTotalComments($simple_blog_article_id);
					
					if($total_comments != 1) {
						$data['total_comment'] = $total_comments . " " . $this->language->get('text_comments');
					} else {
						$data['total_comment'] = $total_comments . " " . $this->language->get('text_comment');
					}

					$article_info['description']	= html_entity_decode($article_info['description'], ENT_QUOTES, 'UTF-8');
					
					$data['article_info'] = $article_info;
					
					$data['article_date_modified'] = date($this->language->get('text_date_format'), strtotime($article_info['date_modified']));
				
					$data['article_additional_description']	= array();
					$article_additional_description = $this->model_extension_so_theme_simple_blog_article->getArticleAdditionalDescription($simple_blog_article_id);
					if ($article_additional_description) {
						foreach ($article_additional_description as $additional_description) {
							$additional_description['additional_description']	= html_entity_decode($additional_description['additional_description'], ENT_QUOTES, 'UTF-8');
							$data['article_additional_description'] = $additional_description;
						}
					}
					
                    // related product
					$related_product = $this->model_extension_so_theme_simple_blog_article->getArticleProductRelated($simple_blog_article_id);
					
					$data['products'] = array();
					
					foreach($related_product as $product) {
						
						$product_info = $this->model_catalog_product->getProduct($product['product_id']);
						
						$image = ($product_info['image']) ? $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_related_width'), $this->config->get('config_image_related_height')) : false;
						
						$price = ($this->customer->isLogged() || !$this->config->get('config_customer_price')) ? $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']) : false;
						
						$special = ((float)$product_info['special']) ? $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']) : false;
						
						$rating = ($this->config->get('config_review_status')) ? (int)$product_info['rating'] : false;
						
						$data['products'][] = array(
							'product_id' => $product_info['product_id'],
							'thumb'   	 => $image,
							'name'    	 => $product_info['name'],
							'price'   	 => $price,
							'special' 	 => $special,
							'rating'     => $rating,
							'reviews'    => sprintf($this->language->get('text_reviews'), (int)$product_info['reviews']),
							'href'    	 => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
						);
					}		
				
					// author related information
					$author_info = $this->model_extension_so_theme_simple_blog_article->getAuthorInformation($article_info['simple_blog_author_id']);
					
					//print "<pre>"; print_r($author_info); exit;
					
					if($author_info) {
						
						$data['author_name'] = $author_info['name'];
						
						if($author_info['image']) {
							$data['author_image'] = $this->model_tool_image->resize($author_info['image'], 100, 100);
						} else {
							$data['author_image'] = $this->model_tool_image->resize('no_image.jpg', 100, 100);
						}
						
						$data['author_description'] = html_entity_decode($author_info['description'], ENT_QUOTES, 'UTF-8');
					}	
					
					// related article information
					$data['text_related_article'] = $this->language->get('text_related_article');
                    $data['text_author_information'] = $this->language->get('text_author_information');
					$data['text_posted_by'] = $this->language->get('text_posted_by');
					$data['text_on'] = $this->language->get('text_on');
					$data['text_updated'] = $this->language->get('text_updated');
					$data['text_created'] = $this->language->get('text_created');
					$data['text_comment_on_article'] = $this->language->get('text_comment_on_article');
					$data['text_view_comment'] = $this->language->get('text_view_comment');
					$data['button_continue_reading'] = $this->language->get('button_continue_reading');
										
					$related_articles = $this->model_extension_so_theme_simple_blog_article->getRelatedArticles($article_info['simple_blog_article_id']);
                    $data['related_articles'] = array();
                    
                    foreach($related_articles as $article) {
                        $data['related_articles'][] = array(
    						'simple_blog_article_id'	=> $article['simple_blog_article_id'],
    						'article_title'		=> $article['article_title'],
    						'simple_blog_author_id'	=> $article['simple_blog_author_id'],
    						'image'				=> $article['image'],
    						'description'		=> $article['description'],
    						'author_name'		=> $article['author_name'],
    						'date_added'		=> date('F jS, Y', strtotime($article['date_added'])),
    						'date_modified'		=> date('F jS, Y', strtotime($article['date_modified'])),
    						'total_comment'		=> $article['total_comment'],
                            'article_href'      => $this->url->link('extension/so_theme/simple_blog/article_info', 'simple_blog_article_id=' . $article['simple_blog_article_id'], true),
                            'author_href'       => $this->url->link('extension/so_theme/simple_blog/author', 'simple_blog_author_id=' . $article['simple_blog_author_id'], true)
    					);
                    }
                    
					//print "<pre>"; print_r($data['related_articles']); die;
                    if($this->config->has('simple_blog_related_articles')) {
                        $data['simple_blog_related_articles'] = $this->config->get('simple_blog_related_articles');   
                    }
                    
                    if($this->config->has('simple_blog_author_information')) {
                        $data['simple_blog_author_information'] = $this->config->get('simple_blog_author_information');   
                    }
                    
                    if($this->config->has('simple_blog_share_social_site')) {
                        $data['simple_blog_share_social_site'] = $this->config->get('simple_blog_share_social_site');
                    }
					
                    if($this->config->has('simple_blog_articles_style')) {
                        $data['simple_blog_articles_style'] = $this->config->get('simple_blog_articles_style');
                    } 
					if(isset($this->request->get['article'])) {
                        $data['simple_blog_articles_style'] = $this->request->get['article'];
					}
				}	

				$data['breadcrumbs'] = array();
	
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home'),
					'separator' => false
				);
		
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('extension/so_theme/simple_blog/article'),
					'separator' => ' :: '
				);

                $data['breadcrumbs'][] = array(
                    'text' => $article_info['article_title'],
                    'href' => $this->url->link('extension/so_theme/simple_blog/article_info&simple_blog_article_id='. $this->request->get['simple_blog_article_id'])
                );


                $data['column_left'] = $this->load->controller('common/column_left');
        		$data['column_right'] = $this->load->controller('common/column_right');
        		$data['content_top'] = $this->load->controller('common/content_top');
        		$data['content_bottom'] = $this->load->controller('common/content_bottom');
        		$data['footer'] = $this->load->controller('common/footer');
        		$data['header'] = $this->load->controller('common/header');

			  
               // Captcha
				if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('register', (array)$this->config->get('config_captcha_page'))) {
					$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'));
					
				} else {
					$data['captcha'] = '';
				}

                $data['column_right_blog'] = $this->load->controller('common/right_blog');
                $store_id = $this->config->get('config_store_id');
                $customisation_blog = $this->config->get('customisation_blog_store');
                $data['post_columns'] = 1;
                if (isset($customisation_blog["post_columns"][$store_id])) {$data['post_columns'] = $customisation_blog["post_columns"][$store_id];}
				
				$soconfig = new \ClassSoconfig($this->registry); 
				$platforms_mobile 		= $soconfig->get_settings('platforms_mobile');
				if($this->session->data['device']=='mobile' && $platforms_mobile) {
					$this->response->setOutput($this->load->view('extension/so_theme/somobile/template/simple_blog/article_info', $data));
				} else {
					$this->response->setOutput($this->load->view('extension/so_theme/simple_blog/article_info', $data));
				}
                


            } else {
				
				$url = '';

				if (isset($this->request->get['article_id'])) {
					$url .= '&article_id=' . $this->request->get['article_id'];
				}
	
				if (isset($this->request->get['page'])) {
					$url .= '&page=' . $this->request->get['page'];
				}
	
				if (isset($this->request->get['limit'])) {
					$url .= '&limit=' . $this->request->get['limit'];
				}
				
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('text_home'),
					'href'      => $this->url->link('common/home'),
					'separator' => false
				);
				
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('heading_title'),
					'href'      => $this->url->link('extension/so_theme/simple_blog/article'),
					'separator' => $this->language->get('text_separator')
				);
				
				$data['breadcrumbs'][] = array(
					'text'      => $this->language->get('text_category_error'),
					'href'      => $this->url->link('blog/author', $url),
					'separator' => $this->language->get('text_separator')
				);
	
				$this->document->setTitle($this->language->get('text_article_error'));
	
				$data['heading_title'] = $this->language->get('text_article_error');
	
				$data['text_error'] = $this->language->get('text_article_error');
	
				$data['button_continue'] = $this->language->get('button_continue');
	
				$data['continue'] = $this->url->link('common/home');
	
				$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . '/1.1 404 Not Found');
                
                $data['column_left'] = $this->load->controller('common/column_left');
        		$data['column_right'] = $this->load->controller('common/column_right');
        		$data['content_top'] = $this->load->controller('common/content_top');
        		$data['content_bottom'] = $this->load->controller('common/content_bottom');
        		$data['footer'] = $this->load->controller('common/footer');
        		$data['header'] = $this->load->controller('common/header');

                $this->response->setOutput($this->load->view('error/not_found', $data));

            }
		}

	}