<?php 


namespace Shiperr;



class LocationByKeyword
{
	//Send Url 

	public static function sendRequest(int $adm_level, string $keyword){
		$apiEndpoint = Shiperr::$baseUrl . '/v3/location';
		$queryParams = http_build_query([
	        'adm_level' => $adm_level,
	        'keyword' => $keyword
	    ]);

	    $url = $apiEndpoint . '?' . $queryParams;
	    $ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    	'Accept: application/json',
	        'X-API-Key: ' . Shiperr::$apiKey
	    ]);
	    $response = curl_exec($ch);
	    curl_close($ch);
 
	    return json_decode($response);
	}
	// Country
	public static function getLocationCountryByKeywords(string $keyword) : object
    {
		return self::sendRequest(1, $keyword);
    }

    // 
    public static function getLocationProvinceByKeywords(string $keyword) : object
    {
		return self::sendRequest(2, $keyword);
    }

	public static function getLocationCityByKeywords(string $keyword) : object
    {
		return self::sendRequest(3, $keyword);
    }

    public static function getLocationSuburbByKeywords(string $keyword) : object
    {
		return self::sendRequest(4, $keyword);
    }


    public static function getLocationAreaByKeywords(string $keyword) : object
    {
		return self::sendRequest(5, $keyword);
    }

}