<?php
namespace Shiperr;

class Pricing
{
	public static function sendRequest(array $parameters, string $url, boolean $post){
		// $apiEndpoint = Shiperr::$baseUrl . '/v3/pricing/domestic';

		$data = json_encode($parameters);
	    $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if($post){
        	curl_setopt($ch, CURLOPT_POST, 1);
        	curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    	'Accept: application/json',
	        'X-API-Key: '. Shiperr::$apiKey,
	    ]);
	    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
	    $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

	    if ($error) {
            throw new Exception('cURL Error: ' . $error);
        }

        return json_decode($response);
	}
	public static function createOrder(array $data){
		$url = Shiperr::$baseUrl . '/v3/order';

		return self::sendRequest($data, $url, True);
	}

	public static function getOrderDetailsByOrderId(string $orderId){
		$url = Shiperr::$baseUrl . '/v3/order/'. $orderId;
		$data = array('message'=>'method get');
		return self::sendRequest($data, $url, False);
	}

	public static function getOrderDetailsByExternalId(string $externalId){
		$url = Shiperr::$baseUrl . '/v3/order/external-id/'. $externalId;
		$data = array('message'=>'method get');

		return self::sendRequest($data, $url, False);
	}
	public static function cancelOrder(string $orderId, array $reason){
		$url = Shiperr::$baseUrl . '/v3/order/'. $orderId;

		$data = json_encode($reason);
 		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE"); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    	'Accept: application/json',
	        'X-API-Key: '. Shiperr::$apiKey,
	    ]);
	    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

		$response = curl_exec($ch);
		$error = curl_error($ch);
		curl_close($ch);

	    if ($error) {
            throw new Exception('cURL Error: ' . $error);
        }

		return json_decode($response);
	}
	public static function getShippingLabel(array $orderId, boolean $label){
		$url = Shiperr::$baseUrl . '/v3/order/label';
		$type = "RCP";
		if($label){
			$type = "LBL"
		}
		$request_data = [
			'id'=> $orderId,
			'type'=> $type
		];

		return self::sendRequest($request_data, $url, True);

	}
	


}