<?php


namespace App\Console\Commands;


use App\Http\Controllers\api\RajaGadaiOutController;
use App\Http\Controllers\ParameterGlobalController;
use App\Models\Coupon;
use App\Models\Customer;
use App\Models\CustomerCoupon;
use App\Models\JobLog;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class BenefitLevelJob extends Command
{
    protected $signature = 'job:benefit';

    protected $description = 'Share voucher ke customer dengan level tertentu';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $now = Carbon::now();
        $job = JobLog::where('coupon_id', '!=', null)->where('status', 0)
            ->orWhere('status', 9)
            ->where('count_sending', '<', ParameterGlobalController::counter_send_notif())
            ->orderBy('id')->get();
        foreach ($job as $item) {
            $benefitTime = Carbon::parse($item->tgl_proses)->format('Y-m-d');
                if ($benefitTime <= $now->format('Y-m-d')){
                    $voucher = Coupon::where('coupon_id', $item->coupon_id)->first();
                    $customer = Customer::find($item->customer_id);
                    $item->update([
                        'status' => 2,
                        'updated_who' => 'cronjob reward voucher',
                        'count_sending' => $item->count_sending + 1
                    ]);
                    if ($item->status == 2){
                        $code = RajaGadaiOutController::redeem($customer->no_hp, $customer->nomor_member, $voucher->external_code, $voucher->nominal);
                        $codeVoucher = json_decode($code, true);
                        if ($codeVoucher['status'] == true){
                            CustomerCoupon::create([
                                'customer_id' => $customer->customer_id,
                                'coupon_id' => $voucher->coupon_id,
                                'masa_berlaku' => $codeVoucher['data']['expired'],
                                'nominal' => $codeVoucher['data']['voucherAmount'],
                                'created_who' => 'cronjob reward voucher',
                                'tgl_redeem' => $codeVoucher['data']['startEffective'],
                                'status_aktif' => true,
                                'code_coupon' => $codeVoucher['data']['codeVoucher'],
                                'sumber' => 'Benefit Level'
                            ]);
                            $this->info('Reward berhasil dikirim');
                            Log::info('Reward berhasil dikirim');

                        } elseif ($codeVoucher['status'] == false) {
                            $item->update([
                                'status' => 9,
                                'updated_who' => 'cronjob reward voucher',
                            ]);
                            $this->info('Reward gagal dikirim');
                            $this->info($codeVoucher);
                        }
                    }
                } else {
                    $this->info('Tidak ada reward yang dikirim');
                    Log::error('Tidak ada reward yang dikirim');
                }

        }
    }
}
