<?php

namespace App\Console\Commands;

use App\Models\Coupon;
use App\Models\CustomerCoupon;
use Illuminate\Console\Command;
use  App\Models\Berita;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
class BeritaCron extends Command
{

    protected $signature = 'update:berita';


    protected $description = 'Update Berita';


    public function __construct()
    {
        parent::__construct();
    }


    public function handle()
    {
        $now = Carbon::now();
        $date_now = $now->format('Y-m-d');
        $artikel = Berita::select('tgl_inactive','id','subject','tgl_active')->get();
        if ($artikel != null){
            foreach($artikel as $artikels){
                $id = $artikels->id;
                if($artikels->tgl_inactive <= $date_now){
                    Berita::where('id', $id)->update([
                        'status' => 'Tidak Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);
                    $this->info('Data Berita berhasil di update');
                    Log::info('Data Berita berhasil di update');
                }else{
                    $this->info('Data Berita belum ada yg di ubah');
                    Log::info('Data Berita belum ada yg di ubah');
                }
                if($artikels->tgl_active == $date_now){
                    Berita::where('id', $id)->update([
                        'status' => 'Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);

                }
            }
        }else{
            $this->info('Data Berita belum ada yg di ubah');
            Log::info('Data Berita belum ada yg di ubah');
        }

        $voucher = Coupon::select('tgl_inactive','coupon_id','tgl_active')->get();
        if ($voucher != null){
            foreach($voucher as $vouchers){
                $id = $vouchers->coupon_id;
                if($vouchers->tgl_inactive <= $date_now){
                    Coupon::find($id)->update([
                        'status' => 'Tidak Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);
                    $this->info('Data Voucher berhasil di update');
                    Log::info('Data Voucher berhasil di update');
                }else{
                    $this->info('Data Voucher belum ada yg di ubah');
                    Log::info('Data Voucher belum ada yg di ubah');
                }
                if($vouchers->tgl_active == $date_now){
                    Coupon::find($id)->update([
                        'status' => 'Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);

                }
            }
        }else{
            $this->info('Data Voucher belum ada yg di ubah');
            Log::info('Data Voucher belum ada yg di ubah');
        }

        $customerVoucher = CustomerCoupon::where('masa_berlaku','<=', $date_now)->get();
        if ($customerVoucher){
            foreach ($customerVoucher as $vcr){
                $vcr->update([
                    'status_aktif' => false,
                    'used_for' => 'Masa berlaku habis'
                ]);
                $this->info('Data Voucher berhasil diupdate');
                Log::info('Data Voucher berhasil diupdate');
            }
        } else {
            $this->info('Data Voucher belum ada yg diubah');
            Log::info('Data Voucher belum ada yg diubah');
        }
    }
}
