<?php

namespace App\Console\Commands;

use App\Models\Coupon;
use App\Models\DataGadai;
use App\Models\JobLog;
use App\Models\Level;
use Illuminate\Console\Command;
use  App\Models\Customer;
use  App\Models\Notification;
use Carbon\Carbon;
use Google_Client;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class CronJobLog extends Command
{

    protected $signature = 'job:notifikasi';

    protected $description = 'Save job ke table job log';

    private function getGoogleAccessToken(){

        $credentialsFilePath = 'public\assets\json\raja-gadai-firebase-adminsdk-5ip5v-39f562484d.json'; //replace this with your actual path and file name
        $client = new Google_Client();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
        return $token['access_token'];
    }
    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        try {
            $notification = Notification::all();
            $customer = Customer::where('fcmtoken_firebase', '!=', null)->get();
            $benefitCustomer = Customer::all();

            foreach ($customer as $cs){

                foreach ($notification as $notif){
                    $job = JobLog::where('customer_id', $cs->customer_id)->where('notification_id', $notif->id)->first();
                    $jobSuccess = DB::table('job_log_success')->where('customer_id', $cs->customer_id)->where('notification_id', $notif->id)->first();
                    if ($notif->type_id == 1){
                        $tglLahir = Carbon::parse($cs->tanggal_lahir)->format('m-d');
                        $tahunSekarang = Carbon::now()->year;
                        $schedule = Carbon::parse($notif->schedule)->format('H:i:s');
                        $birthDay = Carbon::createFromFormat('Y-m-d H:i:s', $tahunSekarang. '-'.  $tglLahir. ' '. $schedule);
                        $now = Carbon::now()->format('Y-m-d H:i:s');
                        if (empty($job) && empty($jobSuccess)) {
                            if ($birthDay < $now){
                                $birthDay->addYear();
                            }
                            JobLog::create([
                                'notification_id' => $notif->id,
                                'customer_id' => $cs->customer_id,
                                'created_who' => 'cronjob',
                                'status' => 0,
                                'count_sending' => 0,
                                'tgl_proses' => $birthDay,
                                'tipe_proses' => 'Birthday'
                            ]);
                            $this->info('Job Birthday berhasil dibuat');
                            Log::info('Job Birthday Dibuat');
                        } else {
                            $tglLahir = Carbon::parse($cs->tanggal_lahir)->format('m-d');
                            $tahunSekarang = Carbon::now()->year;
                            $schedule = Carbon::parse($notif->schedule)->format('H:i:s');
                            $birthDay = Carbon::createFromFormat('Y-m-d H:i:s', $tahunSekarang. '-'.  $tglLahir. ' '. $schedule);
                            $now = Carbon::now()->format('Y-m-d H:i:s');
                            if (!empty($jobSuccess)){
                                if ($birthDay < $now){
                                    $birthDay->addYear();
                                }
                                if (empty($job)){
                                    JobLog::create([
                                        'notification_id' => $notif->id,
                                        'customer_id' => $cs->customer_id,
                                        'created_who' => 'cronjob',
                                        'status' => 0,
                                        'count_sending' => 0,
                                        'tgl_proses' => $birthDay,
                                        'tipe_proses' => 'Birthday'
                                    ]);
                                    $this->info('Job Birthday berhasil dibuat');
                                    Log::info('Job Birthday Dibuat');
                                }
                            }
                            if (!empty($job)){
                                if ($birthDay < $now){
                                    $birthDay->addYear();
                                }
                                if ($job->status == 0){
                                    $job->update([
                                        'notification_id' => $notif->id,
                                        'customer_id' => $cs->customer_id,
                                        'updated_who' => 'cronjob',
                                        'status' => 0,
                                        'count_sending' => 0,
                                        'tgl_proses' => $birthDay,
                                        'tipe_proses' => 'Birthday'
                                    ]);
                                    $this->info('Job Birthday berhasil diupdate');
                                    Log::info('Job Birthday Diupdate');
                                }
                            }
                        }
                    } elseif($notif->type_id == 4){
                        $reminder = Carbon::parse($notif->schedule)->format('H:i:s');
                        $dataGadai = DataGadai::where('customer_id', $cs->customer_id)->get();

                        foreach ($dataGadai as $gadai){
                            $reminderJob = Carbon::parse($gadai->tgl_jatuh_tempo)->subDays($notif->reminder)->format('Y-m-d');
                            $job = JobLog::where('customer_id', $cs->customer_id)->where('notification_id', $notif->id)
                                ->where('gadai_number', $gadai->nomor_transaksi)
                                ->first();
                            $jobSuccess = DB::table('job_log_success')->where('customer_id', $cs->customer_id)
                                ->where('notification_id', $notif->id)
                                ->where('gadai_number', $gadai->nomor_transaksi)
                                ->orderBy('id', 'desc')
                                ->first();
                            $now = Carbon::now()->format('Y-m-d');
                            if (empty($job) && empty($jobSuccess)){
                                if ($reminderJob >= $now){
                                    JobLog::create([
                                        'notification_id' => $notif->id,
                                        'customer_id' => $cs->customer_id,
                                        'gadai_number' => $gadai->nomor_transaksi,
                                        'created_who' => 'cronjob',
                                        'status' => 0,
                                        'count_sending' => 0,
                                        'tgl_proses' => $reminderJob.' '.$reminder,
                                        'tipe_proses' => 'Reminder'
                                    ]);
                                    $this->info('Job Reminder berhasil dibuat');
                                    Log::info('Job Reminder Dibuat');
                                }
                            } else {
                                if (!empty($job)){
                                    if ($job->status == 0) {
                                        $job->update([
                                            'status' => 0,
                                            'tgl_proses' => $reminderJob . ' ' . $reminder,
                                        ]);
                                    }
                                    $this->info('Job Reminder sudah ada');
                                    Log::info('Job Reminder sudah ada');
                                }
                                if (!empty($jobSuccess) && empty($job)){
                                    $timePast = Carbon::parse($jobSuccess->tgl_proses)->format('Y-m-d H:i:s');
                                    $timeNew = Carbon::createFromFormat('Y-m-d H:i:s', $reminderJob. ' ' . $reminder);
                                    if ($timePast < $timeNew){
                                        JobLog::create([
                                            'notification_id' => $notif->id,
                                            'customer_id' => $cs->customer_id,
                                            'gadai_number' => $gadai->nomor_transaksi,
                                            'created_who' => 'cronjob',
                                            'status' => 0,
                                            'count_sending' => 0,
                                            'tgl_proses' => $reminderJob.' '.$reminder,
                                            'tipe_proses' => 'Reminder'
                                        ]);
                                        $this->info('Job Reminder berhasil dibuat');
                                        Log::info('Job Reminder Dibuat');
                                    }
                                }
                            }
                        }
                    } elseif ($notif->type_id == 7){
                        $reminder = Carbon::parse($notif->schedule)->format('H:i:s');
                        $dataGadai = DataGadai::where('customer_id', $cs->customer_id)->get();

                        foreach ($dataGadai as $gadai){
                            $reminderJob = Carbon::parse($gadai->tgl_lelang)->subDays($notif->reminder)->format('Y-m-d');
                            $job = JobLog::where('customer_id', $cs->customer_id)->where('notification_id', $notif->id)
                                ->where('gadai_number', $gadai->nomor_transaksi)
                                ->first();
                            $jobSuccess = DB::table('job_log_success')->where('customer_id', $cs->customer_id)
                                ->where('notification_id', $notif->id)
                                ->where('gadai_number', $gadai->nomor_transaksi)
                                ->orderBy('id', 'desc')
                                ->first();
                            $now = Carbon::now()->format('Y-m-d');
                            if (empty($job) && empty($jobSuccess)){
                                if ($reminderJob >= $now){
                                    JobLog::create([
                                        'notification_id' => $notif->id,
                                        'customer_id' => $cs->customer_id,
                                        'gadai_number' => $gadai->nomor_transaksi,
                                        'created_who' => 'cronjob',
                                        'status' => 0,
                                        'count_sending' => 0,
                                        'tgl_proses' => $reminderJob.' '.$reminder,
                                        'tipe_proses' => 'Reminder'
                                    ]);
                                    $this->info('Job Reminder berhasil dibuat');
                                    Log::info('Job Reminder Dibuat');
                                }
                            } else {
                                if (!empty($job)){
                                    if ($job->status == 0) {
                                        $job->update([
                                            'status' => 0,
                                            'tgl_proses' => $reminderJob . ' ' . $reminder,
                                        ]);
                                    }
                                    $this->info('Job Reminder sudah ada');
                                    Log::info('Job Reminder sudah ada');
                                }
                                if (!empty($jobSuccess) && empty($job)){
                                    $timePast = Carbon::parse($jobSuccess->tgl_proses)->format('Y-m-d H:i:s');
                                    $timeNew = Carbon::createFromFormat('Y-m-d H:i:s', $reminderJob. ' ' . $reminder);
                                    if ($timePast < $timeNew){
                                        JobLog::create([
                                            'notification_id' => $notif->id,
                                            'customer_id' => $cs->customer_id,
                                            'gadai_number' => $gadai->nomor_transaksi,
                                            'created_who' => 'cronjob',
                                            'status' => 0,
                                            'count_sending' => 0,
                                            'tgl_proses' => $reminderJob.' '.$reminder,
                                            'tipe_proses' => 'Reminder'
                                        ]);
                                        $this->info('Job Reminder berhasil dibuat');
                                        Log::info('Job Reminder Dibuat');
                                    }
                                }
                            }
                        }
                    } elseif ($notif->type_id == 5){
                        $promosiTime = Carbon::parse($notif->schedule)->format('H:i');
                        $promosiDay = Carbon::parse($notif->schedule_day)->format('Y-m-d');
                        $now = Carbon::now()->format('Y-m-d');
                        if (empty($job) && empty($jobSuccess)){
                            if ($promosiDay >= $now){
                                JobLog::create([
                                    'notification_id' => $notif->id,
                                    'customer_id' => $cs->customer_id,
                                    'created_who' => 'cronjob',
                                    'status' => 0,
                                    'count_sending' => 0,
                                    'tgl_proses' => $promosiDay.' '.$promosiTime,
                                    'tipe_proses' => 'Promosi'
                                ]);
                                $this->info('Job Promosi berhasil dibuat');
                                Log::info('Job Promosi Dibuat');
                            }
                        } else {
                            $this->info('Job Promosi sudah ada');
                            Log::info('Job Promosi sudah ada');
                        }
                    }
                }
            }

            foreach ($benefitCustomer as $bn){

                $level = Level::where('point', '<=', $bn->level_point)
                    ->orderByDesc('point')
                    ->first();

                if ($level->coupon_id != null){
                    $tahunDanBulan = now()->addMonth()->format('Y-m');
                    $hasil = Carbon::createFromFormat('Y-m-d H:i:s', $tahunDanBulan . '-' . 1 . ' ' . '00:00:00');
                    $job = JobLog::where('customer_id', $bn->customer_id)->where('coupon_id', '!=', null)->where('level_id', $level->level_id)->first();
                    if (empty($job)){
                        JobLog::create([
                            'coupon_id' => $level->coupon_id,
                            'customer_id' => $bn->customer_id,
                            'created_who' => 'cronjob',
                            'status' => 0,
                            'count_sending' => 0,
                            'tgl_proses' => $hasil,
                            'level_id' => $level->level_id,
                            'tipe_proses' => 'Reward Voucher'
                        ]);
                        $this->info('Job Reward Voucher berhasil dibuat');
                        Log::info('Job Reward Voucher Dibuat');
                    } else {
                        $now = Carbon::now();
                        if ($job->status == 0){
                            $job->update([
                                'status' => 0,
                                'coupon_id' => $level->coupon_id,
                                'level_id' => $level->level_id,
                                'updated_who' => 'cronjob'
                            ]);
                            if ($job->tgl_proses < $now){
                                $job->update([
                                    'status' => 0,
                                    'coupon_id' => $level->coupon_id,
                                    'updated_who' => 'cronjob',
                                    'tgl_proses' => $hasil,
                                ]);
                            }
                        }
                        $this->info('Job Reward Voucher sudah ada');
                        Log::info('Job Reward Voucher sudah ada');
                    }
                } else {
                    $this->info('Customer tidak mendapatkan voucher');
                    Log::info('Customer tidak mendapatkan voucher');
                }
            }

        }catch (\Exception $e){
            Log::error($e->getMessage());
            Log::error($e->getTraceAsString());

            $this->info($e->getTraceAsString());
        }
    }
}
