<?php


namespace App\Console\Commands;


use App\Models\Customer;
use App\Models\CustomerCoupon;
use App\Models\DataGadai;
use App\Models\HistoryExtend;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class GadaiCheck extends Command
{
    protected $signature = 'update:dataGadai';
    protected $description = 'Update Data Gadai';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $dataGadai = DataGadai::all();
        $now = Carbon::now();
        $time = $now->format('H:i');
        foreach ($dataGadai as $gadai) {
//            if ($gadai->waiting_payment === TRUE){
//                $update = Carbon::parse($gadai->tgl_payment)->format('Y-m-d H:i:s');
//                $history_extend = HistoryExtend::where('no_transaksi',$gadai->nomor_transaksi)
//                    ->where('status', 'Pending')->first();
//                $time = $now->diffInHours($update);
//                $this->info($gadai->nomor_transaksi . ' ' . $time);
//
//                if ($time >= 11){
//                    $customer = Customer::where('nomor_member',$history_extend->no_member)->first();
//                    $history_extend->update([
//                       'status' => 'Cancel',
//                        'updated_who' => 'cronjob'
//                    ]);
//
//                    if ($history_extend->point > 0){
//                        $customer->update([
//                                'point' => DB::raw('point +'.$history_extend->point),
//                                'sumber_mutasi' => 'Cancel Payment',
//                            ]);
//                        $this->info($customer->nama_customer);
//                    }
//
//                    if ($history_extend->code_voucher != null){
//                        $voucher = CustomerCoupon::where('code_coupon', $history_extend->code_voucher)->first();
//                        $voucher->update([
//                            'status_aktif' => True,
//                            'updated_who' => 'cronjob'
//                        ]);
//                        $this->info('Voucher berhasil dikembalikan');
//                    }
//                    $gadai->update([
//                        'waiting_payment' => False,
//                        'payment_link' => null,
//                        'tgl_payment' => null,
//                        'updated_who' => 'cronjob'
//                    ]);
//                }
//            }

            $lelang = Carbon::parse($gadai->tgl_lelang);
            if ($lelang <= $now){
                if ($time >= '21:00') {
                    $gadai->update([
                        'status' => 'Lelang',
                        'updated_who' => 'cronjob'
                    ]);
                }
            }

        }
    }
}
