<?php


namespace App\Console\Commands;


use App\Http\Controllers\ParameterGlobalController;
use App\Models\Customer;
use App\Models\DataGadai;
use App\Models\DataGadaiDetail;
use App\Models\JobLog;
use App\Models\JobLogReport;
use App\Models\MasterConfig;
use App\Models\Notification;
use App\Models\NotificationCustomer;
use Carbon\Carbon;
use Google_Client;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class NotificationJob extends Command
{
    protected $signature = 'job:notifikasiSend';

    protected $description = 'Kirim Notifikasi';

    private function getGoogleAccessToken(){

        $credentialsFilePath = 'public/assets/json/raja-gadai-firebase-adminsdk-5ip5v-39f562484d.json'; //replace this with your actual path and file name
        $client = new Google_Client();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
        return $token['access_token'];
    }

    private function sendNotif($message, $log, $id){
        $config = MasterConfig::where('key', 'API_FIREBASE')->first();
        $apiurl = $config->value;

        $headers = [
            'Authorization: Bearer ' . $this->getGoogleAccessToken(),
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiurl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));

        $result = curl_exec($ch);

        if ($result === FALSE) {
            //Failed
            die('Curl failed: ' . curl_error($ch));
        }
        $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        curl_close($ch);

        Log::info($result);
        JobLogReport::create([
           'job_log_id' => $log->id,
           'status' => $http_status,
           'tgl_proses' => Carbon::now(),
            'response' => $result,
            'request' => json_encode($message),
        ]);
        $this->info('Report berhasil dibuat');
        if ($http_status == 200) {

            $this->info('Berhasil Mengirim Notifikasi Status ' . $http_status);
            $this->info($result);
            Log::channel('mobile')->info('Berhasil Mengirim Notifikasi Status ' . $http_status);
            Log::channel('mobile')->info($result);

        } else {

            $this->error('Permintaan gagal: Status ' . $http_status);
            Log::channel('mobile')->error($result);

        }

        return $http_status;
    }

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        while (true){
        $now = Carbon::now()->format('Y-m-d H:i');
        $job = JobLog::where('notification_id', '!=', null)->where('status', 0)
            ->orWhere('status', 9)
            ->where('count_sending', '<', ParameterGlobalController::counter_send_notif())
            ->orderBy('id')->get();
            try {
            foreach ($job as $log) {
                $sendNotif = Carbon::parse($log->tgl_proses)->format('Y-m-d H:i');
                $message = [];

                    if ($sendNotif <= $now) {
                        $customer = Customer::where('customer_id', $log->customer_id)->first();

                        Log::error('Notification ID = '.$log->notification_id);
                        $notifikasi = Notification::where('id', $log->notification_id)->first();

                        Log::error('Notification DATA = '.$notifikasi);

                        if (empty($notifikasi)){
                            continue;
                        }
                        $description = $notifikasi->description;
                        $description = str_replace('&nbsp;', ' ', $description);
                        $description = str_replace("#nama#", $customer->nama_customer, $description);
                        if ($notifikasi->type_id == 1) {
                            $tanggal_lahir = Carbon::createFromFormat('Y-m-d', $customer->tanggal_lahir);
                            $sekarang = Carbon::now();
                            $umur = $sekarang->diffInYears($tanggal_lahir);
                            $description = str_replace('#umur#', $umur, $description);
                            $notification = NotificationCustomer::create([
                                'customer_id' => $customer->customer_id,
                                'notification_id' => $notifikasi->id,
                                'read_notification' => false,
                                'description' => $description,
                                'created_who' => 'cronjob'
                            ]);
                            $message = [
                                'message' => [
                                    "token" => $customer->fcmtoken_firebase,
                                    "notification" => [
                                        "body" => strip_tags($description),
                                        "title" => $notifikasi->subject
                                    ],
                                    "data" => [
                                        "id" => (string)$notification->id,
                                        "module" => "Birthday"
                                    ]
                                ]
                            ];
                            $log->update([
                                'status' => 2,
                                'count_sending' => $log->count_sending + 1
                            ]);
                            Log::info('status log 2');
                            if ($log->status == 2) {
                                $this->info('log berhasil diupdate');
                                Log::info('log berhasil dibuat');
                                $send = self::sendNotif($message, $log, $notification->id);
                                if ($send == 200 || $send == "200") {
                                    $this->info('notif berhasil dipush');
                                    Log::info('Log berhasil dihapus');
                                    $log->delete();

                                } else {
                                    $this->info('Notif gagal dipush');
                                    $log->update([
                                        'status' => 9
                                    ]);
                                    Log::info('notif gagal di push');
                                    $inbox = NotificationCustomer::find($notification->id)->delete();
                                    Log::info('status log 9');
                                }
                            } else {
                                $this->info('log gagal diupdate');
                                $inbox = NotificationCustomer::find($notification->id)->delete();
                            }

                        } else if ($notifikasi->type_id == 2 || $notifikasi->type_id == 3 || $notifikasi->type_id == 4 || $notifikasi->type_id == 6 || $notifikasi->type_id == 7) {
                            $gadai = DataGadai::where('nomor_transaksi', $log->gadai_number)->first();
                            if (!empty($gadai)) {
                                $description = str_replace('#nomor_transaksi#', $gadai->nomor_transaksi, $description);

                                if ($notifikasi->type_id == 2) {
                                    $gadaiDetail = DataGadaiDetail::where('data_gadai_id', $gadai->id)->first();
                                    $description = str_replace('#barang#', $gadaiDetail->nama_barang, $description);
                                    $message = [
                                        'message' => [
                                            "token" => $customer->fcmtoken_firebase,
                                            "notification" => [
                                                "body" => strip_tags($description),
                                                "title" => $notifikasi->subject
                                            ],
                                            "data" => [
                                                "id" => (string)$gadai->id,
                                                "module" => "Gadai Baru"
                                            ]
                                        ]
                                    ];
                                    $log->update([
                                            'status' => 2,
                                            'count_sending' => $log->count_sending + 1
                                        ]);
                                    Log::info('status log 2');
                                    $notification = NotificationCustomer::create([
                                        'customer_id' => $customer->customer_id,
                                        'notification_id' => $notifikasi->id,
                                        'read_notification' => false,
                                        'description' => $description,
                                        'created_who' => 'cronjob'
                                    ]);
                                    if ($log->status == 2) {

                                        $send = $this->sendNotif($message, $log, $notification->id);
                                        if ($send == 200 || $send == "200") {
                                            $this->info('notif berhasil dipush');
                                            Log::info('Log berhasil dihapus');
                                            $log->delete();

                                        } else {
                                            $log->update([
                                                'status' => 9,
                                            ]);
                                            Log::info('status log 9');
                                            $this->info('Notif gagal dipush');
                                            $inbox = NotificationCustomer::find($notification->id)->delete();
                                        }
                                    } else {
                                        $inbox = NotificationCustomer::find($notification->id)->delete();
                                    }
                                } elseif ($notifikasi->type_id == 3) {
                                    $notification = NotificationCustomer::create([
                                        'customer_id' => $customer->customer_id,
                                        'notification_id' => $notifikasi->id,
                                        'read_notification' => false,
                                        'description' => $description,
                                        'created_who' => 'cronjob'
                                    ]);
                                    $message = [
                                        'message' => [
                                            "token" => $customer->fcmtoken_firebase,
                                            "notification" => [
                                                "body" => strip_tags($description),
                                                "title" => $notifikasi->subject
                                            ],
                                            "data" => [
                                                "id" => (string)$gadai->id,
                                                "module" => "Pelunasan"
                                            ]
                                        ]
                                    ];

                                    $log->update([
                                        'status' => 2,
                                        'count_sending' => $log->count_sending + 1
                                    ]);
                                    Log::info('status log 2');
                                    if ($log->status == 2) {
                                        $send = $this->sendNotif($message, $log, $notification->id);
                                        if ($send == 200 || $send == "200") {
                                            $this->info('notif berhasil dipush');
                                            Log::info('Log berhasil dihapus');
                                            $log->delete();

                                        } else {
                                            $log->update([
                                                'status' => 9,
                                            ]);
                                            Log::info('status log 9');
                                            $this->info('Notif gagal dipush');
                                            $inbox = NotificationCustomer::find($notification->id)->delete();
                                        }
                                    } else {
                                        $inbox = NotificationCustomer::find($notification->id)->delete();
                                    }

                                } elseif ($notifikasi->type_id == 4 || $notifikasi->type_id == 7) {
                                    $gadaiDetail = DataGadaiDetail::where('data_gadai_id', $gadai->id)->first();
                                    $description = str_replace('#barang#', $gadaiDetail->nama_barang, $description);
                                    $description = str_replace('#hari#', $notifikasi->reminder, $description);
                                    $notification = NotificationCustomer::create([
                                        'customer_id' => $customer->customer_id,
                                        'notification_id' => $notifikasi->id,
                                        'read_notification' => false,
                                        'description' => $description,
                                        'created_who' => 'cronjob'
                                    ]);
                                    $message = [
                                        'message' => [
                                            "token" => $customer->fcmtoken_firebase,
                                            "notification" => [
                                                "body" => strip_tags($description),
                                                "title" => $notifikasi->subject
                                            ],
                                            "data" => [
                                                "id" => (string)$gadai->id,
                                                "module" => "Reminder"
                                            ]
                                        ]
                                    ];
                                    $log->update([
                                        'status' => 2,
                                        'count_sending' => $log->count_sending + 1
                                    ]);
                                    Log::info('status log 2');
                                    if ($log->status == 2) {
                                        $send = $this->sendNotif($message, $log, $notification->id);
                                        if ($send == 200 || $send == "200") {
                                            $this->info('notif berhasil dipush');
                                            Log::info('Log berhasil dihapus');
                                            $log->delete();
                                        } else {
                                            $log->update([
                                                'status' => 9,
                                            ]);
                                            Log::info('status log 9');
                                            $this->info('Notif gagal dipush');
                                            $inbox = NotificationCustomer::find($notification->id)->delete();
                                        }
                                    } else {
                                        $inbox = NotificationCustomer::find($notification->id)->delete();
                                    }
                                } elseif ($notifikasi->type_id == 6) {
                                    $notification = NotificationCustomer::create([
                                        'customer_id' => $customer->customer_id,
                                        'notification_id' => $notifikasi->id,
                                        'read_notification' => false,
                                        'description' => $description,
                                        'created_who' => 'cronjob'
                                    ]);
                                    $message = [
                                        'message' => [
                                            "token" => $customer->fcmtoken_firebase,
                                            "notification" => [
                                                "body" => strip_tags($description),
                                                "title" => $notifikasi->subject
                                            ],
                                            "data" => [
                                                "id" => (string)$gadai->id,
                                                "module" => "Perpanjang Gadai"
                                            ]
                                        ]
                                    ];
                                    $log->update([
                                        'status' => 2,
                                        'count_sending' => $log->count_sending + 1
                                    ]);
                                    Log::info('status log 2');
                                    if ($log->status == 2) {
                                        $send = $this->sendNotif($message, $log, $notification->id);
                                        if ($send == 200 || $send == "200") {
                                            $this->info('notif berhasil dipush');
                                            Log::info('Log berhasil dihapus');
                                            $log->delete();

                                        } else {
                                            $log->update([
                                                'status' => 9,
                                            ]);
                                            Log::info('status log 9');
                                            $this->info('Notif gagal dipush');
                                            $inbox = NotificationCustomer::find($notification->id)->delete();
                                        }
                                    } else {
                                        $inbox = NotificationCustomer::find($notification->id)->delete();
                                    }
                                }
                            }
                        } elseif ($notifikasi->type_id == 5) {
                            $notification = NotificationCustomer::create([
                                'customer_id' => $customer->customer_id,
                                'notification_id' => $notifikasi->id,
                                'read_notification' => false,
                                'description' => $description,
                                'created_who' => 'cronjob'
                            ]);
                            $message = [
                                'message' => [
                                    "token" => $customer->fcmtoken_firebase,
                                    "notification" => [
                                        "body" => strip_tags($description),
                                        "title" => $notifikasi->subject
                                    ],
                                    "data" => [
                                        "id" => (string)$notification->id,
                                        "module" => "Promosi"
                                    ]
                                ]
                            ];
                            $log->update([
                                'status' => 2,
                                'count_sending' => $log->count_sending + 1
                            ]);
                            Log::info('status log 2');
                            if ($log->status == 2) {
                                $send = $this->sendNotif($message, $log, $notification->id);
                                if ($send == 200 || $send == "200") {
                                    $this->info('notif berhasil dipush');
                                    Log::info('Log berhasil dihapus');
                                    $log->delete();

                                } else {
                                    $log->update([
                                        'status' => 9,
                                    ]);
                                    Log::info('status log 9');
                                    $this->info('Notif gagal dipush');
                                    $inbox = NotificationCustomer::find($notification->id)->delete();
                                }
                            } else {
                                $inbox = NotificationCustomer::find($notification->id)->delete();
                            }
                        }
                    }
                }
            }catch(\Exception $e) {
                    Log::error($e->getMessage());
                    Log::error($e->getTraceAsString());
                }

        sleep(1);
        }

    }
}
