<?php


namespace App\Console\Commands;


use App\Models\Customer;
use App\Models\Level;
use App\Models\Notification;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class ResetXpCron extends Command
{

    protected $signature = 'reset:xp';


    protected $description = 'Command description';


    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $customer = Customer::all();

        foreach ($customer as $cs)
        {
            $cust = Customer::find($cs->customer_id);
            if($cust->level_point != null){
                $level = Level::where('point', '<=', $cust->level_point)
                    ->orderBy('point', 'desc')->first();
                $cs->update([
                    'level_point' => $level->point,
                    'sumber_mutasi' => 'Reset XP Akhir Tahun',
                    'updated_who' => 'cronjob'
                ]);
                $this->info('XP berhasil di reset');
            }
        }
    }
}
