<?php


namespace App\Console\Commands;



use App\Models\Coupon;
use App\Models\Customer;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class VoucherCron extends Command
{
    protected $signature = 'voucher:update';
    protected $description = 'Command description';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $now = Carbon::now();
        $date_now = $now->format('Y-m-d');
        $voucher = Coupon::select('tgl_inactive','coupon_id','tgl_active')->get();
        $customer = Customer::select('fcmtoken_firebase','customer_id')->get();
        if ($voucher != null){
            foreach($voucher as $vouchers){
                $id = $vouchers->coupon_id;
                if($vouchers->tgl_inactive <= $date_now){
                    Coupon::find($id)->update([
                        'status' => 'Tidak Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);
                    $this->info('Data Voucher berhasil di update');
                    Log::info('Data Voucher berhasil di update');
                }else{
                    $this->info('Data Voucher belum ada yg di ubah');
                    Log::info('Data Voucher belum ada yg di ubah');
                }
                if($vouchers->tgl_active == $date_now){
                    Coupon::find($id)->update([
                        'status' => 'Aktif',
                        'updated_who'=> 'Cronjob'
                    ]);

                }
            }
        }else{
            $this->info('Data Voucher belum ada yg di ubah');
            Log::info('Data Voucher belum ada yg di ubah');
        }
    }
}
