<?php

namespace App\Exports;

use App\Models\Cases;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;

class CaseExport implements FromView
{
    public function view(): View
    {
        $data = Cases::select('id', 'code', 'created_who', 'updated_who', 'created_at', 'updated_at')
            ->orderBy('id', 'asc')
            ->get();

        return view('items.excel_all', ['data' => $data]);
    }
}

?>