<?php

namespace App\Exports;

use App\Models\Destination;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;

class DestinationExport implements FromView
{
    public function view(): View
    {
        $destinations = Destination::select('id','code','name','created_who', 'updated_who', 'created_at', 'updated_at')
            ->orderBy('id', 'asc')
            ->get();

        return view('destinations.excel_all', ['destinations' => $destinations]);
    }
}

?>
