<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;

class ErrorDestinationExport implements FromView
{
    private $dataError;
    private $errors;

    public function __construct(array $dataError, array $errors)
    {
        $this->dataError = $dataError;
        $this->errors = $errors;
    }

    public function view(): View
    {
        return view('destinations.error_destination', [
            'data' => $this->dataError,
            'message' => $this->errors,
        ]);
    }
}
