<?php
namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithTitle;


class ErrorMappingExport implements WithMultipleSheets
{
    private $dataErrors;
    private $errorMessages;
    private $dataErrorDetails;
    private $errorMessageDetails;

    public function __construct(array $dataErrors, array $errorMessages, array $dataErrorDetails, array $errorMessageDetails)
    {
        $this->dataErrors = $dataErrors;
        $this->errorMessages = $errorMessages;
        $this->dataErrorDetails = $dataErrorDetails;
        $this->errorMessageDetails = $errorMessageDetails;
    }

    public function sheets(): array
    {
        $sheets = [];

        // Main error sheet
        $sheets[] = new class ($this->dataErrors, $this->errorMessages) implements FromCollection, WithHeadings, WithTitle {
            private $dataErrors;
            private $errorMessages;

            public function __construct(array $dataErrors, array $errorMessages)
            {
                $this->dataErrors = $dataErrors;
                $this->errorMessages = $errorMessages;
            }

            public function collection()
            {
                return collect($this->dataErrors);
            }

            public function headings(): array
            {
                return [
                    'Destination',
                    'Lot Process',
                    'Case',
                    'Start Date',
                    'End Date',
                    'Error Message'
                ];
            }

            public function title(): string
            {
                return "Error Mapping";
            }
        };

        // Detail error sheet
        $sheets[] = new class ($this->dataErrorDetails, $this->errorMessageDetails) implements FromCollection, WithHeadings, WithTitle {
            private $dataErrorDetails;
            private $errorMessageDetails;

            public function __construct(array $dataErrorDetails, array $errorMessageDetails)
            {
                $this->dataErrorDetails = $dataErrorDetails;
                $this->errorMessageDetails = $errorMessageDetails;
            }

            public function collection()
            {
                return collect($this->dataErrorDetails);
            }
            public function view(): View
            {
                return view('mapping.error_mapping_detail', [
                    'data' => $this->dataErrorDetails,
                    'message' => $this->errorMessageDetails,
                ]);
            }

            public function headings(): array
            {
                return [
                    'Sequence',
                    'Unique Number',
                    'Part Number',
                    'Address',
                    'Header Line',
                    'Error Message Detail'
                ];
            }

            public function title(): string
            {
                return "Error Mapping Detail";
            }
        };

        return $sheets;
    }
}
