<?php

namespace App\Exports;

use App\Models\Item;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;

class ItemExports implements FromView
{
    public function view(): View
    {
        $data = Item::select('id', 'code', 'name', 'address', 'created_who', 'updated_who', 'created_at', 'updated_at')
            ->orderBy('id', 'asc')
            ->get();

        return view('items.excel_all', ['data' => $data]);
    }
}

?>