<?php

namespace App\Exports;

use App\Models\Mapping;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class MappingExport implements FromCollection, WithHeadings, WithMapping
{
    public function collection()
    {
        return Mapping::with('destination', 'lotProcess', 'mappingCase', 'details')->get();
    }

    public function headings(): array
    {
        return [
            'Destination',
            'Lot Process',
            'Case',
            'Start Date',
            'End Date',
            'Unique Number',
            'Part Number',
            'Address',
            'Sequence'
        ];
    }

    public function map($mapping): array
    {
        $rows = [];
        $index = 1;

        foreach ($mapping->details as $detail) {
            $rows[] = [
                optional($mapping->destination)->code,
                optional($mapping->lotProcess)->code,
                optional($mapping->mappingCase)->code,
                $mapping->start_date,
                $mapping->end_date,
                $detail->item->code,
                $detail->item->name,
                $detail->item->address,
                $detail->sequence,
            ];
        }

        return $rows;
    }
}
