<?php

namespace App\Exports;

use App\Models\Mapping;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Color;


class MappingTemplateExport implements WithMultipleSheets
{
    public function sheets(): array
    {
        $sheets = [];

        // Sheet untuk data upload
        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return collect([
                    ['CTH', 'MP', 'C1', '2023-01-01', '2023-12-31', '*Note : Put your data starting from this row'],
                ]);
            }

            public function headings(): array
            {
                return ['Destination', 'Lot Process', 'Case', 'Start Date', 'End Date'];
            }

            public function title(): string
            {
                return 'Data Header';
            }
        };
        //sheet detail

        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return collect([
                    ['1', '7001', '1234-05678','EX-1','1', 'Example data, Put your data starting from this row'],

                    // Data kosong untuk template
                ]);
            }

            public function headings(): array
            {
                return ['Sequence', 'Unique Number','Part Number','Address', 'Header Line'];
            }

            public function title(): string
            {
                return 'Data Detail';
            }
        };


        // Sheet untuk m_destination
        // Gantikan dengan data sesuai dengan struktur m_destination
        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return \App\Models\Destination::select('code', 'name')
                    ->whereNull('deleted_at')
                    ->orderBy('created_at', 'asc')
                    ->get();
            }

            public function headings(): array
            {
                return [ 'Code', 'Name']; // Sesuaikan dengan header yang sesuai
            }

            public function title(): string
            {
                return 'Destination Reference'; // Nama sheet
            }
        };

        // Sheet untuk m_lot_process
        // Gantikan dengan data sesuai dengan struktur m_lot_process
        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return \App\Models\LotProcess::select('code')
                    ->whereNull('deleted_at')
                    ->orderBy('created_at', 'asc')
                    ->get();
            }

            public function headings(): array
            {
                return [ 'Code']; // Sesuaikan dengan header yang sesuai
            }

            public function title(): string
            {
                return 'Lot Process Reference'; // Nama sheet
            }
        };

        // Sheet untuk m_case
        // Gantikan dengan data sesuai dengan struktur m_case
        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return \App\Models\Cases::select( 'code')
                    ->whereNull('deleted_at')
                    ->orderBy('created_at', 'asc')
                    ->get();
            }

            public function headings(): array
            {
                return [ 'Code'];
            }
            public function title(): string
            {
                return 'Case Reference'; // Nama sheet
            }
        };

        // Sheet untuk m_item
        // Gantikan dengan data sesuai dengan struktur m_item
        $sheets[] = new class implements FromCollection, WithTitle, WithHeadings {
            public function collection()
            {
                return \App\Models\Item::select( 'code', 'name', 'address')
                    ->whereNull('deleted_at')
                    ->orderBy('created_at', 'asc')
                    ->get();
            }

            public function headings(): array
            {
                return [ 'Unique Number', 'Part Number', 'Address']; // Sesuaikan dengan header yang sesuai
            }

            public function title(): string
            {
                return 'Part Number Reference'; // Nama sheet
            }
        };

        return $sheets;
    }
}
