<?php

namespace App\Http\Controllers;

use App\Models\Cases;
use App\Models\Destination;
use App\Models\Item;
use App\Models\LotProcess;
use App\Models\Mapping;
use Illuminate\Http\Request;
use App\Models\User;  
use Auth;
use DB;
use Illuminate\Support\Facades\Hash; 
use Kutia\Larafirebase\Facades\Larafirebase;

class HomeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    //===============================================================================
    public function index()
    {
        $user = User::count();
        $destinations = Destination::count();
        $lot_processes = LotProcess::count();
        $cases = Cases::count();
        $part_numbers = Item::count();
        $mappings = Mapping::count();
        return view('home',compact('user', 'destinations', 'lot_processes', 'cases', 'part_numbers', 'mappings'));
    }

    //===============================================================================
    public function editprofile()
    {
        $data = DB::table('users')->where('id', Auth::user()->id)->get();
        return view('user.editprofile', compact('data'));
    }

    public function aksieditprofile(Request $request)
    {
        if ($request->password != '') {

            $usr = User::where('id', Auth::user()->id)->first();
            if (!Hash::check($request->oldpassword, $usr->password)) {
                return redirect('home')->with('error', 'Password Lama Salah');
            } else {
                $usr->update([
                    'name' => $request->nama,
                    'username' => $request->username,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                ]);
            }
        } else {
            User::where('id', Auth::user()->id)
                ->update([
                    'name' => $request->nama,
                    'username' => $request->username,
                    'email' => $request->email,

                ]);
        }
        return redirect('home')->with('status', 'Sukses memperbarui profile');
    }
    public function showFormPesan()
    {
        return view('pesan');
    }
    public function updateToken(Request $request)
    {
        try {
            $request->user()->update(['fcm_token' => $request->token]);
            return response()->json([
                'success' => true
            ]);
        } catch (\Exception $e) {
            report($e);
            return response()->json([
                'success' => false
            ], 500);
        }
    }
    public function notification(Request $request)
    {

        $request->validate([
            'title' => 'required',
            'message' => 'required'
        ]);

        try {
            $fcmTokens = Customer::whereNotNull('fcmtoken_firebase')->pluck('fcmtoken_firebase')->toArray();

            Notification::send(null, new SendPushNotification($request->title, $request->message, $fcmTokens));


            return redirect()->back()->with('success', 'Notification Sent Successfully!!');
        } catch (\Exception $e) {
            report($e);
            return redirect()->back()->with('error', 'Something goes wrong while sending notification.');
        }
    }
}
