<?php

namespace App\Http\Controllers;

use App\Models\MasterConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;

class MasterConfigController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:view-config', ['only' => ['index', 'listdata']]);
        $this->middleware('permission:edit-config', ['only' => ['edit','update']]);
    }

    public function index()
    {
        return view('master-config.index');
    }

    public function listdata()
    {
        $data = MasterConfig::select('id', 'key', 'description', 'value')
            ->get();

        return DataTables::of($data)->make(true);
    }

    public function edit($id)
    {
        $masterConfig = MasterConfig::find($id);
        return view('master-config.edit', compact('masterConfig'));
    }

    public function update(Request $request,$id)
    {
        $masterConfig = MasterConfig::find($id);

        $masterConfig->update([
            'key' => $request->key,
            'description' => $request->description,
            'value' => $request->value,
            'updated_who' => Auth::user()->name,
        ]);

        return redirect()->route('masterConfig.index')
            ->with('success', 'Data Berhasil Diupdate');
    }
}
