<?php

namespace App\Http\Controllers;

use App\Models\ScheduleSync;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class ScheduleSyncController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = [];
        return view('schedule-sync.index', compact('data'));
    }

    public function listdata()
    {
        $data = ScheduleSync::select('id', 'time_sync')
            ->orderBy('id', 'asc')
            ->get();

        return DataTables::of($data)->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'time_sync' => 'required',
        ]);

        $scheduleSync = new ScheduleSync();
        $scheduleSync->time_sync = $request->time_sync;
        $scheduleSync->created_who = auth()->user()->name;
        $scheduleSync->save();

        return response()->json(['success' => true]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            // Temukan data berdasarkan ID
            $data = ScheduleSync::findOrFail($id);

            // Hapus data
            $data->delete();

            return response()->json(['success' => true]);
        } catch (Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()]);
        }
    }


}
