<?php

namespace App\Http\Controllers;

use App\Models\WhitelistIp;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Yajra\DataTables\DataTables;


class WhitelistIpController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('permission:view-whitelist', ['only' => ['index','show', 'listdata']]);
        $this->middleware('permission:create-whitelist', ['only' => ['create','store', 'uploadLibur']]);
        $this->middleware('permission:edit-whitelist', ['only' => ['edit','update']]);
        $this->middleware('permission:delete-whitelist', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {

        return view('whitelist-ip.index');
    }

    public function listdata()
    {
        $data = WhitelistIp::select('ip_address', 'status', 'id')->get();

        return DataTables::of($data)->make(true);
    }
    public function create()
    {
        $whitelistIp = new WhitelistIp();
        return view('whitelist-ip.create', compact('whitelistIp'));
    }


    public function store(Request $request)
    {
        $validate = $request->validate([
            'ip_address' => [
                'required',
                Rule::unique('whitelist_ip','ip_address')
            ],
            'status' => 'required',
        ],
            [
                'status.required' => 'Status belum diisi',
                'ip_address.required' => 'Ip Address belum diisi',
                'ip_address.unique' => 'Ip Address sudah digunakan'
            ]);
        $whitelistIp = WhitelistIp::create($request->all());

        if($request->action=='save_and_close'){
            return redirect()->route('whitelist.index')
                ->with('success', 'IP Berhasil Ditambah');
        }else{
            return redirect()->route('whitelist.create')
                ->with('success', 'IP Berhasil Ditambah');
        }
    }


    public function edit($id)
    {
        $whitelistIp = WhitelistIp::find($id);

        return view('whitelist-ip.edit', compact('whitelistIp'));
    }


    public function update(Request $request,$id)
    {
        $validate = $request->validate([
            'ip_address' => [
                'required',
                Rule::unique('whitelist_ip','ip_address')->ignore($id)
            ],
            'status' => 'required',
        ],
        [
            'status.required' => 'Status belum diisi',
            'ip_address.required' => 'Ip Address belum diisi',
            'ip_address.unique' => 'Ip Address sudah digunakan'
        ]);
        $whitelistIp = WhitelistIp::find($id);
        $whitelistIp->update($request->all());

        return redirect()->route('whitelist.index')
            ->with('success', 'IP Berhasil Diubah');
    }

    public function destroy($id)
    {
        $whitelistIp = WhitelistIp::find($id)->delete();

        return redirect()->route('whitelist.index')
            ->with('success', 'IP Berhasil Dihapus');
    }
}
