<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\Controller;
use App\Models\Destination;

class APIController extends Controller
{

    public function __construct()
    {
        // $this->middleware('auth.api')->except(
        //     'sendOtp',
        //     'sendOtp2',
        //     'signIn',
        //     'verifyAccount',
        //     'register',
        //     'resetPassword',
        //     'greetings',
        //     'guest',
        //     'generateNumber',
        //     'checkServer',
        //     'otpConfig',
        //     'verifyPhoneNumber'
        // );
    }

    public function checkVersions(Request $request)
    {
        // Tangkap data JSON dari request
        $datas = $request->json()->all();
        $response = array();
        if (!empty($datas)) {
            foreach ($datas as $module => $version) {
                if ($this->get_module($module, $version)) {
                    $response['versions'][] = $module;
                }
            }
        }

        $sql = "SELECT time_sync FROM schedule_sync";
        $datas = DB::select($sql);

        if (!empty($datas)) {
            $result = [];
            // Iterasi melalui array awal
            foreach ($datas as $item) {
                $result[] = $item->time_sync;
            }
            $response['syncTimes'] = $result;
        }

        // Mengembalikan respons dalam bentuk JSON
        return response()->json($response);
    }

    private function get_module($module, $version)
    {
        $module = strtoupper(trim($module));
        try {
            switch ($module) {
                case 'DESTINATION':
                    $module = 'm_destination';
                    break;
                case 'LOT_PROCESS':
                    $module = 'm_lot_process';
                    break;
                case 'CASE':
                    $module = 'm_case';
                    break;
                case 'MAPPING':
                    $module = 't_mapping';
                    break;
                default:
                    $module = '';
                    break;
            }

            if ($module) {
                $sql = "SELECT 1 FROM t_versioning WHERE module='$module' and version > $version";
                $data = DB::select($sql);

                if (!empty($data)) {
                    return true;
                }
            }
        } catch (Exception $e) {
            // echo "Terjadi kesalahan dalam menjalankan query: " . $e->getMessage();
        }
        return false;
    }

    public function getDestinations(Request $request)
    {
        $response = array();
        $log_id = date('YmdHis');
        Log::channel('log_api')->info('url(' . $log_id . '): ' . $request->url());
        Log::channel('log_api')->info('Request(' . $log_id . '): ' . json_encode($request->input()));
        if ($request->input('version') >= 0) {
            $version = (int)$request->input('version');
            $sql = "SELECT id,code,name,version,(case when coalesce(deleted_at,null) is null then false else true end) as deleted  FROM m_destination WHERE version > $version";
            $datas = DB::select($sql);

            if (!empty($datas)) {
                $response['destinations'] = $datas;
            }
        }

        // Mengembalikan respons dalam bentuk JSON
        Log::channel('log_api')->info('Response(' . $log_id . '): ' . json_encode($response));
        return response()->json($response);
    }

    public function getLotProcesses(Request $request)
    {
        $response = array();
        $log_id = date('YmdHis');
        Log::channel('log_api')->info('url(' . $log_id . '): ' . $request->url());
        Log::channel('log_api')->info('Request(' . $log_id . '): ' . json_encode($request->input()));
        if ($request->input('version') >= 0) {
            $version = (int)$request->input('version');
            $sql = "select id,code,name,version,(case when coalesce(deleted_at,null) is null then false else true end) as deleted from m_lot_process where version > $version";
            // print_r($sql);exit;
            $datas = DB::select($sql);

            if (!empty($datas)) {
                $response['lotProcesses'] = $datas;
            }
        }

        // Mengembalikan respons dalam bentuk JSON
        Log::channel('log_api')->info('Response(' . $log_id . '): ' . json_encode($response));
        return response()->json($response);
    }

    public function getCases(Request $request)
    {
        $response = array();
        $log_id = date('YmdHis');
        Log::channel('log_api')->info('url(' . $log_id . '): ' . $request->url());
        Log::channel('log_api')->info('Request(' . $log_id . '): ' . json_encode($request->input()));
        if ($request->input('version') >= 0) {
            $version = (int)$request->input('version');
            $sql = "select id,code,name,version,(case when coalesce(deleted_at,null) is null then false else true end) as deleted from m_case where version > $version";
            $datas = DB::select($sql);

            if (!empty($datas)) {
                $response['cases'] = $datas;
            }
        }

        // Mengembalikan respons dalam bentuk JSON
        Log::channel('log_api')->info('Response(' . $log_id . '): ' . json_encode($response));
        return response()->json($response);
    }

    public function getMappings(Request $request)
    {
        $response = array();
        $log_id = date('YmdHis');
        Log::channel('log_api')->info('url(' . $log_id . '): ' . $request->url());
        Log::channel('log_api')->info('Request(' . $log_id . '): ' . json_encode($request->input()));
        if ($request->input('version') >= 0) {
            $version = (int)$request->input('version');
            $base_url = url('/');
            $sql = "SELECT 
                    --distinct
                    a.id,
                    m1.id AS \"destinationId\",
                    m2.id AS \"lotProcessId\",
                    a.case_id AS \"caseId\",
                    a.start_date AS \"startDate\",
                    a.end_date AS \"endDate\",
                    a.version,
                    (case when coalesce(a.deleted_at,null) is null then false else true end) as deleted,
                    b.id AS details_id,
                    b.sequence AS index,
                    m4.name AS \"partNumber\",
                    m4.code AS \"uniqueNumber\",
                    m4.address,
                    concat('$base_url/',b.image) AS \"imageUrl\"
                    FROM t_mapping a
                    LEFT JOIN m_destination m1 ON m1.id=a.destination_id
                    LEFT JOIN m_lot_process m2 ON m2.id=a.lot_process_id
                    LEFT JOIN m_case m3 ON m3.id=a.case_id
                    LEFT JOIN t_mapping_detail b ON b.mapping_id=a.id
                    LEFT JOIN m_item m4 ON m4.id=b.item_id 
                    WHERE a.version > $version AND b.deleted_at is null
                    order by id asc";
            $datas = DB::select($sql);
            if (!empty($datas)) {
                $list = array();
                foreach ($datas as $key => $value) {
                    if (isset($list[$value->id])) {
                        $list[$value->id]['details'][] = array(
                            "id" => $value->details_id,
                            "index" => $value->index,
                            "partNumber" => $value->partNumber,
                            "uniqueNumber" => $value->uniqueNumber,
                            "address" => $value->address,
                            "imageUrl" => $value->imageUrl
                        );
                    } else {
                        // array_push($list, $value->id); //masukan ke array
                        $list[$value->id] = array(
                            "id" => $value->id,
                            "destinationId" => $value->destinationId,
                            "lotProcessId" => $value->lotProcessId,
                            "caseId" => $value->caseId,
                            "startDate" => $value->startDate,
                            "endDate" => $value->endDate,
                            "version" => $value->version,
                            "deleted" => $value->deleted,
                        );

                        $list[$value->id]['details'][] = array(
                            "id" => $value->details_id,
                            "index" => $value->index,
                            "partNumber" => $value->partNumber,
                            "uniqueNumber" => $value->uniqueNumber,
                            "address" => $value->address,
                            "imageUrl" => $value->imageUrl
                        );
                    }
                }

                $response['mappings'] = array_values($list);
            }
        }

        // Mengembalikan respons dalam bentuk JSON
        Log::channel('log_api')->info('Response(' . $log_id . '): ' . json_encode($response));
        return response()->json($response);
    }
}
