<?php

namespace App\Http\Middleware;

use App\Models\Customer;
use App\Models\Guest;
use App\Models\User;
use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class AuthMobile
{

    public function handle($request, Closure $next)
    {
        $token = $this->parseToken($request);

        $now = Carbon::now()->format('Y-m-d H:i:s');
        $cust = Customer::where('fcmtoken', $token)->first();
        $guest = Guest::where('token', $token)->first();

        if ($cust == null)
        {
            if ($guest == null){
                return response()->json('Unauthorized', 401);
            } else {
                $lastActivity = Guest::find($guest->id)->update([
                   'last_activity' => $now
                ]);
            }
        } else {
            $lastActivity = Customer::find($cust->customer_id)->update([
                'last_activity' => $now
            ]);
        }
        if (!$token) {
            return response()->json('Unauthorized', 401);
        }

        if (!$this->authenticateUser($token)) {
            return response()->json('Invalid token', 401);
        }

        return $next($request);
    }

    protected function parseToken($request)
    {
        $header = $request->header('Authorization');

        if (Str::startsWith($header, 'Bearer ')) {
            return Str::after($header, 'Bearer ');
        }

        return null;
    }

    protected function authenticateUser($requestToken)
    {
        $user = Customer::where('fcmtoken', $requestToken)->first();
        $guest = Guest::where('token', $requestToken)->first();

        if (!$user && !$guest) {
            return false;
        }

        if ($user != null){
            if ($requestToken !== $user->fcmtoken){
                return false;
            }
        }
        if ($guest != null){
            if ($requestToken !== $guest->token) {
                return false;
            }
        }

        return true;
    }
}
