<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
class CustomerImport implements ToModel, WithHeadingRow
{
    private $errors = [];
    private $rowCount = 0;
    private $errors_2 = [];

    public function generateNumber($lahir)
    {
        DB::beginTransaction();

        try {
            $count = DB::select("select * from fn_getid('member')");
            $data = json_encode($count);
            $id = json_decode($data, true);
            $tglLahir = Carbon::parse($lahir)->format('ym');
            $eightDigitNumber = str_pad($id[0]['fn_getid'], 8, '0', STR_PAD_LEFT);

            $result =  $tglLahir.$eightDigitNumber;

            DB::commit();
            return $result;
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error($e->getTraceAsString());
            Log::error($e->getMessage());
            return 'Terjadi kesalahan: ' . $e->getMessage();
        }
    }

    public function generateReferal(){
        $year = Carbon::now()->format('y');
        $month = Carbon::now()->format('ym');
        $count = DB::select("select * from fn_getid('referral_$year')");
        $data = json_encode($count);
        $id = json_decode($data, true);
        $fourDigit = str_pad($id[0]['fn_getid'], 6, '0', STR_PAD_LEFT);

        return 'RG-'.$month.$fourDigit;
    }

    public function model(array $row)
    {
        $expectedColumns = ['nama_customer',
            'nik',
            'tanggal_lahir',
            'jenis_kelamin',
            'email',
            'password',
            'nomor_handphone',

        ];

        $AfterError = ['nama_customer',
            'nik',
            'tanggal_lahir',
            'jenis_kelamin',
            'email',
            'password',
            'nomor_handphone',
            'pesan_erorr',
        ];
        if (count(array_diff($expectedColumns, array_keys($row))) === 0 || count(array_diff($AfterError, array_keys($row))) === 0) {
            $row['tanggal_lahir'] = date('Y-m-d', strtotime($row['tanggal_lahir']));
            $validator = Validator::make($row, [
                'nama_customer' =>'required|regex:/^[A-Za-z ]+$/|min:2',
                'nik' => 'nullable|digits:16',
                'tanggal_lahir' => 'required|date_format:Y-m-d|before:-17 years',
                'jenis_kelamin' => 'required',
                'email' => 'nullable|email|unique:customer,email',
                'password' => 'required|string|min:8|regex:/^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[@#$%^&+=!])[A-Za-z\d@#$%^&+=!]+$/',
                'nomor_handphone' => 'required|unique:customer,no_hp|min:10|max:13|starts_with:08',

            ]);
            $refCode = $this->generateReferal();
            $no_member = $this->generateNumber($row['tanggal_lahir']);
            $status = 'Belum Diverifikasi';

            if ($validator->fails()) {
                $errors = $validator->errors()->all();
                // $email_errors = array_pluck($errors, 'email');
                foreach ($errors as $key => $error) {
                    $this->errors_2[]= [
                        'nama_customer' =>$row['nama_customer'],
                        'nik' =>$row['nik'],
                        'tanggal_lahir' =>$row['tanggal_lahir'],
                        'gender' => $row['jenis_kelamin'],
                        'email' =>$row['email'],
                        'password' =>$row['password'],
                        'no_hp' =>$row['nomor_handphone'],
                        // 'tanggal_lahir' =>$row['tanggal_lahir'],

                    ];
                }

                // Perform the import


                $this->errors[] =  implode(", ", $errors);
                return null;
            }
            return new Customer([
                'nama_customer' => $row['nama_customer'],
                'nik' => $row['nik'],
                'tanggal_lahir' => $row['tanggal_lahir'],
                'gender' => $row['jenis_kelamin'],
                'email' => $row['email'],
                'password' => Hash::make($row['password']),
                'no_hp' => $row['nomor_handphone'],
                'is_active' => true,
                'nomor_member' => $no_member,
                'referal_code' => $refCode,
                'status'=> $status,
                'point'=> 0,
                'level_point'=> 0,
                'created_who'=> Auth::user()->name
            ]);
        }


    }
    public function getDataErrors()
    {
        $filteredArray = [];
        $seenData = [];

        foreach ($this->errors_2 as $index => $element) {
            $data = $element['no_hp'];
            if (!in_array($data, $seenData)) {
                $filteredArray[] = $element;
                $seenData[] = $data;
            }
        }
        return $filteredArray;
    }

    public function getRowCount()
    {
        return $this->rowCount;
    }

    public function getErrors()
    {
        return $this->errors;
    }

}
