<?php

namespace App\Imports;

use App\Models\LotProcess;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Validators\Failure;

class LotProcessImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use SkipsFailures;

    private $successCount = 0;
    private $errors = [];
    private $errors_2 = [];

    public function model(array $row)
    {
        $validator = Validator::make($row, [
            'code' => 'required',
        ]);

        if ($validator->fails()) {
            $this->errors_2[] = [
                'code' => $row['code'],
                'pesan_error' => implode(" ", $validator->errors()->all())
            ];
            $this->errors[] = implode(" ", $validator->errors()->all());
            return null;
        }

        try {
            if (LotProcess::where('code', $row['code'])->exists()) {
                $errorMessage = "The code {$row['code']} already exists.";
                $this->errors_2[] = [
                    'code' => $row['code'],
                    'pesan_error' => $errorMessage
                ];
                $this->errors[] = $errorMessage;
                return null;
            }

            $LotProcess = new LotProcess([
                'code' => $row['code'],
                'created_who' => Auth::user()->name,
                'updated_who' => Auth::user()->name,
            ]);

            $LotProcess->save();
            $this->successCount++;
        } catch (\Exception $e) {
            $errorMessage = "The code {$row['code']} already exists.";
            $this->errors_2[] = [
                'code' => $row['code'],
                'pesan_error' => $errorMessage
            ];
            $this->errors[] = $errorMessage;
        }
    }

    public function rules(): array
    {
        return [
            '*.code' => 'required',
        ];
    }

    public function onFailure(Failure ...$failures)
    {
        foreach ($failures as $failure) {
            $this->errors[] = $failure->errors();
        }
    }

    public function getSuccessCount()
    {
        return $this->successCount;
    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function getDataErrors()
    {
        return $this->errors_2;
    }
}
