<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cases extends Model
    /**
     * Class Case
     *
     * @property $id
     * @property $code
     * @property $nama
     * @property $created_at
     * @property $created_who
     * @property $updated_at
     * @property $updated_who
     * @property $deleted_at
     *
     * @package App
     * @mixin \Illuminate\Database\Eloquent\Builder
     */
{
    public $timestamps = true;
    use SoftDeletes;

    protected $table = 'm_case';

    static $rules = [
        'code' => 'required',
        'name' => 'required'
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['code','name','created_who','updated_who'];

}

