<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mapping extends Model
{
    use SoftDeletes;

    protected $table = 't_mapping';
    protected $fillable = [
        'destination_id',
        'lot_process_id',
        'case_id',
        'start_date',
        'end_date',
        'created_who',
        'updated_who'
    ];

    // Definisi relasi
    public function destination()
    {
        return $this->belongsTo(Destination::class, 'destination_id');
    }

    public function lotProcess()
    {
        return $this->belongsTo(LotProcess::class, 'lot_process_id');
    }

    public function mappingCase()
    {
        return $this->belongsTo(Cases::class, 'case_id');
    }

    // Relasi ke MappingDetail
    public function details()
    {
        return $this->hasMany(MappingDetail::class, 'mapping_id');
    }
}
