<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MappingDetail extends Model
{
    use SoftDeletes;

    public $timestamps = true;

    protected $table = 't_mapping_detail';

    protected $fillable = [
        'mapping_id',
        'item_id',
        'sequence',
        'image',
        'created_who',
        'updated_who'
    ];

    static $rules = [
        'mapping_id' => 'required',
        'item_id' => 'required',
        'sequence' => 'required',
        'image' => 'nullable|image|max:2048',
        'created_who' => 'required',
        'updated_who' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Define relationships
     */
    public function mapping()
    {
        return $this->belongsTo(Mapping::class, 'mapping_id');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'item_id');
    }
}
