<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class WhitelistIp
 *
 * @property $id
 * @property $ip_address
 * @property $status
 * @property $created_at
 * @property $updated_at
 *
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class WhitelistIp extends Model
{

    public $timestamps = true;

    protected $table = 'whitelist_ip';
    static $rules = [
		'ip_address' => 'required',
		'status' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['ip_address','status'];



}
