<?php

namespace App\Providers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Validator::extend('afterIfJamBukaNotNull', function ($attribute, $value, $parameters, $validator) {
            $jamBukaValues = $validator->getData()[$attribute];
            $jamBukaValue = $jamBukaValues[$parameters[1]];

            if (!empty($jamBukaValue)) {
                return strtotime($value) > strtotime($jamBukaValue);
            }

            return true;
        });
      
    }
}
