<?php


namespace App\Services;


use App\Models\ParameterGlobal;

class ParameterGlobalService
{
    protected $parameters = [];

    public function __construct()
    {
        $globalParameters = ParameterGlobal::all();

        foreach ($globalParameters as $parameter) {
            $this->parameters[$parameter->key_name] = $this->castValue($parameter->value, $parameter->tipe_data);
        }
    }

// ...

    protected function castValue($value, $tipe_data)
    {
        // Mengonversi nilai sesuai dengan tipe data
        switch ($tipe_data) {
            case 'string':
                return (string) $value;
            case 'integer':
                return (int) $value;
            case 'boolean':
                return (bool) $value;
            // Tambahkan jenis data lain sesuai kebutuhan
            default:
                return $value;
        }
    }

    public function get($key)
    {
        $parameter = ParameterGlobal::where('key_name', $key)->first();

        if ($parameter) {
            return $this->castValue($parameter->value, $parameter->tipe_data);
        }

        return null;
    }

    public function set($key, $value, $tipe_data = 'string')
    {
        // Simpan nilai parameter ke dalam database atau perbarui jika sudah ada
        $parameter = ParameterGlobal::updateOrCreate(
            ['key_name' => $key],
            ['value' => $value, 'tipe_data' => $tipe_data]
        );

        // Update nilai parameter dalam cache
        $this->parameters[$key] = $this->castValue($value, $tipe_data);

        return $parameter;
    }

}
