<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConfigSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $formattedTime = Carbon::now()->format('Y-m-d H:i:s');
        DB::table('master_config')->truncate();
        DB::table('master_config')->updateOrInsert([
            'id' => 1,
            'key' => 'OTP_DURATION',
            'description' => 'Durasi waktu untuk customer bisa request kode otp kembali',
            'value' => '120',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 2,
            'key' => 'BASE_URL_RGAPP',
            'description' => 'Url endpoint untuk integrasi dengan RGApp',
            'value' => 'https://rgapi.rajagadai.id/api',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 3,
            'key' => 'CLIENT_ID_SMS',
            'description' => 'Client ID Untuk mengirim sms OTP customer',
            'value' => '1fa2d282-9522-4694-a25c-29d532d28f33',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 4,
            'key' => 'API_KEY_SMS',
            'description' => 'API KEY untuk sms OTP Customer',
            'value' => 'L6kAI2JXLUSwhzoD5C8FhPOkpwHmc5v7Yxela4Z2pjQ=',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 5,
            'key' => 'SENDER_ID_SMS',
            'description' => 'Sender ID untuk sms OTP customer',
            'value' => 'ACM',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 6,
            'key' => 'REGISTER_POINT',
            'description' => 'Bonus Point untuk customer yang register mandiri menggunakan apps',
            'value' => '50',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
        DB::table('master_config')->updateOrInsert([
            'id' => 7,
            'key' => 'API_FIREBASE',
            'description' => 'Url digunakan untuk push notifikasi ke aplikasi melalui firebase',
            'value' => 'https://fcm.googleapis.com/v1/projects/raja-gadai/messages:send',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);

    }
}
