<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class TipeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */

    public function run()
    {
        $currentDateTime = Carbon::now();
        $currentDateTime->setTimezone('Asia/Jakarta');
        $formattedTime = $currentDateTime->format('Y-m-d');
        DB::table('tipe_notification')->insert([
            'id' => 1,
            'tipe' => 'Ulang Tahun',
            'parameter' => '- #nama# untuk Nama Customer,
            - #umur# untuk Umur Customer
            contoh: Selamat Ulang Tahun #nama# di umur yang ke-#umur#.....
            Note: Tidak perlu set tanggal tayang, hanya jam tayang saja',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);

        DB::table('tipe_notification')->insert([
            'id' => 2,
            'tipe' => 'Penggadaian',
            'parameter' => '- #nama# untuk Nama Customer,
            - #nomor_transaksi# untuk Nomor Transaksi gadai
            contoh: Selamat #nama#, Gadai dengan Nomor #nomor_transaksi# berhasil dilakukan...
            Note: Tidak perlu set tanggal tayang dan jam tayang',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);

        DB::table('tipe_notification')->insert([
            'id' => 3,
            'tipe' => 'Pembayaran',
            'parameter' => '- #nama# untuk Nama Customer,
            - #nomor_transaksi# untuk Nomor Transaksi gadai
            contoh: Selamat #nama#, Pembayaran Gadai dengan Nomor #nomor_transaksi# berhasil dilakukan...
            Note: Tidak perlu set tanggal tayang dan jam tayang',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);

        DB::table('tipe_notification')->insert([
            'id' => 4,
            'tipe' => 'Pengingat Tagihan',
            'parameter' => '- #nama# untuk Nama Customer,
            - #nomor_transaksi# untuk Nomor Transaksi gadai,
            - #hari# untuk sisa hari jatuh tempo
            contoh: Halo #nama#, Gadai dengan Nomor #nomor_transaksi# #hari# hari lagi jatuh tempo
            Note: Tidak perlu set tanggal tayang, hanya jam tayang saja',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);

        DB::table('tipe_notification')->insert([
            'id' => 5,
            'tipe' => 'Promosi',
            'parameter' => '- #nama# untuk Nama Customer,
            contoh: Hallo #nama#, Promo 11.11 sebentar lagi.. jangan lupa mampir ke Raja Gadai
            Note: Harus set Tanggal Tayang dan Jam Tayang karena tipe ini untuk sekali kirim saja',
            'created_at'=> $formattedTime,
            'updated_at'=> $formattedTime,
        ]);
    }
}
