$(function () {
    $('#list-data').DataTable({
        processing: true,
        serverSide: true,
        // language: {
        //     url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        // },
        order: [[0, "desc"]],
        ajax: '/list-mapping', // URL endpoint untuk mengambil data dari server
        columns: [
            {
                data: 'id', render: function (data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'destination_name', name: 'destination_name' },
            { data: 'lot_process_name', name: 'lot_process_name' },
            { data: 'case_name', name: 'case_name' },
            { data: 'start_date', name: 'start_date' },
            { data: 'end_date', name: 'end_date' },
            {
                render: function (data, type, row) {
                    var editButton = authUserCanEditData ? ' <a href="/mapping/' + row['id'] + '/edit" class="btn btn-success"><i class="fas fa-pencil-alt"></i></a> ' : '';
                    var deleteButton = authUserCanDeleteData ? '<button class="btn btn-danger" onclick="deleteData(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                    return ' <a href="/mapping/' + parseInt(row['id']) + '" class="btn btn-primary"><i class="fa fa-eye"></i></a> ' + editButton + deleteButton;
                },
                "className": 'text-center',
                "orderable": false,
                "data": null,
            },

        ],
        pageLength: 10,
        lengthMenu: [[5, 10, 20], [5, 10, 20]]
    });

});


function deleteData(id) {
    const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },
        buttonsStyling: true
    })
    swalWithBootstrapButtons.fire({
        title: 'Delete Data ?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Yes',
        cancelButtonText: 'No',
        reverseButtons: true
    }).then((result) => {
        if (result.value) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'DELETE',
                url: '/mapping/' + id,
                data: {
                    '_token': $('input[name=_token]').val(),
                },
                success: function (response) {
                    swalWithBootstrapButtons.fire(
                        'Deleted!',
                        response.message,
                        'success'
                    )
                    $('#list-data').DataTable().ajax.reload();
                },
                error: function (xhr, status, error, response) {
                    swalWithBootstrapButtons.fire(
                        'Failed!',
                        'Data is still related to other data ',
                        'error'
                    )
                }
            });
        }
    })
}
window.deleteData = deleteData;
