$(function () {
    $('#list-data').DataTable({
        processing: true,
        serverSide: true,
        language : {
            url : '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        },
        order: [[0, "desc"]],
        ajax: '/list-config',
        columns: [
            {
                data: 'id', render: function (data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'key' },
            { data: 'description'},
            { data: 'value'},
            {
                render: function (data, type, row) {
                    var editButton = authUserCanEditConfig ? '<a href="/masterConfig/' + row['id'] + '/edit" class="btn btn-success"><i class="fas fa-pencil-alt"></i></a>':'';
                    return editButton;
                },
                "className": 'text-center',
                "orderable": false,
                "data": null,
            },
        ],
        pageLength: 10,
        lengthMenu: [[5, 10, 20], [5, 10, 20]]
    });

});


