$(function () {
    $('#list-data').DataTable({
        processing: true,
        serverSide: true,
        language : {
            url : '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        },
        order: [[0, "desc"]],
        ajax: '/list-notifikasi',
        columns: [
            {
                data: 'id', render: function (data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            { data: 'subject', name: 'subject' },
            { data: 'tipe', name: 'tipe' },
            { data: 'jam', name: 'jam' },
            { data: 'day', name: 'day' },

            {
                render: function (data, type, row) {
                    var editButton = authUserCanEditNotifikasi ? '<a href="/notification/' + row['id'] + '/edit" class="btn btn-success"><i class="fas fa-pencil-alt"></i></a> ':''
                    var deleteButton = authUserCanDeleteNotifikasi ?'<button class="btn btn-danger" onclick="hapusdata(' + row['id'] + ')"><i class="fa fa-trash"></i></button>':'';
                    return '<a href="/notification/' + row['id'] + '" class="btn btn-primary"><i class="fas fa-eye"></i></a>'+ editButton + ' ' + deleteButton;
                },
                "className": 'text-center',
                "orderable": false,
                "data": null,
            },
        ],
        pageLength: 10,
        lengthMenu: [[5, 10, 20], [5, 10, 20]]
    });

});

function hapusdata(kode) {
    const swalWithBootstrapButtons = Swal.mixin({
        customClass: {
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },
        buttonsStyling: true
    })
    swalWithBootstrapButtons.fire({
        title: 'Hapus Data ?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Tidak',
        reverseButtons: true
    }).then((result) => {
        if (result.value) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'DELETE',
                url: '/notification/' + kode,
                data: {
                    '_token': $('input[name=_token]').val(),
                },
                success: function (response) {
                    swalWithBootstrapButtons.fire(
                        'Deleted!',
                            response.message,
                        'success'
                    )
                    $('#list-data').DataTable().ajax.reload();
                },
                error: function (xhr, status, error,response) {
                    swalWithBootstrapButtons.fire(
                        'Gagal!',
                        'Data masih terkait dengan data lain',
                        'error'
                    )
                    $('#list-data').DataTable().ajax.reload();
                }
            });
        }
    })
}
window.hapusdata = hapusdata;
