<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Log In</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="{{asset('images/setting/logo.png')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/fontawesome-free/css/all.min.css')}}">
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <link rel="stylesheet" href="{{asset('assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/dist/css/adminlte.min.css')}}">
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>


<body class="hold-transition login-page bg-grey">
    <div class="login-box">
        <div class="card card-outline card-danger">
            <div class="card-header text-center">
                <img src="{{ asset('images/setting/logo.png') }}" alt="brand Logo" class="img-size-50" style="width: 171px;">
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('login') }}">
                    @csrf
                    <div class="input-group mb-3">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-user"></span>
                            </div>
                        </div>
                        <input id="username" type="text" class="form-control @error('username') is-invalid @enderror" name="username" value="{{ old('username') }}" required autocomplete="new-username" placeholder="Username" autofocus />

                        @error('username')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    <div class="input-group mb-3">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="Password">
                        <div class="input-group-append">
                            <div class="input-group-text" style="background-color: transparent">
                                <span onclick="togglePasswordVisibility(this)" class="fas fa-eye-slash"></span>
                            </div>
                        </div>
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="social-auth-links text-center mb-3">
                                <button type="submit" class="btn btn-block btn-danger">
                                    Login
                                </button>
                                <!-- <a href="{{url('/')}}" class="btn btn-block btn-danger">
                                    Kembali
                                </a> -->
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>
    <script>
        function togglePasswordVisibility(span) {
            const input = span.closest('.input-group').querySelector('input[name="password"]');
            if (input) {
                if (input.type === 'password') {
                    input.type = 'text';
                    span.classList.remove('fa-eye-slash');
                    span.classList.add('fa-eye');
                } else {
                    input.type = 'password';
                    span.classList.remove('fa-eye');
                    span.classList.add('fa-eye-slash');
                }
            }
        }
    </script>

    <script src="{{asset('assets/plugins/jquery/jquery.min.js')}}"></script>
    <script src="{{asset('assets/plugins/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/dist/js/adminlte.min.js')}}"></script>

</body>

</html>