@extends('layouts.app')
@section('content')
<div class="content-header">
    <div class="row">
        @if ($message = Session::get('success'))
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
        @if ($message = Session::get('erorr'))
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
    </div>
</div>
<section class="content">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title float-left">{{ $datas['title'] }}</div>
                    <div class="card-title float-right">
                        @if($access['canDownload'])
                        <a href="{{ route('items.download_template') }}" class="btn btn-info btn-xs"><i class="fa fa-file" aria-hidden="true"></i> Download Template</a>
                        @endif
                        @if($access['canUpload'])
                        <a href="{{ route('items.upload_form') }}" class="btn btn-warning btn-xs"><i class="fa fa-arrow-up" aria-hidden="true"></i> Upload</a>
                        @endif
                        @if($access['canExport'])
                        <a href="{{ route('items.excel_all') }}" class="btn btn-success btn-xs"><i class="fa fa-arrow-down" aria-hidden="true"></i> Export</a>
                        @endif
                        @if($access['canCreate'])
                        <a href="{{ route('items.create') }}" class="btn btn-primary btn-xs"><i class="fas fa-plus"> </i> Add</a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <table id="list-data" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th width="1%">NO</th>
                                <th>UNIQUE NUMBER</th>
                                <th>PART NUMBER</th>
                                <th>ADDRESS</th>
                                <th width="10%">ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    var access = @json($access);
    var authUserCanEditData = access.canEdit;
    var authUserCanDeleteData = access.canDelete;
    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            order: [
                [0, "desc"]
            ],
            ajax: '/list-items',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'address',
                    name: 'address'
                },
                {
                    render: function(data, type, row) {
                        var editButton = authUserCanEditData ? ' <a href="/items/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fas fa-pencil-alt"></i></a> ' : '';
                        var deleteButton = authUserCanDeleteData ? '<button class="btn btn-danger btn-xs" onclick="deleteData(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                        return ' <a href="/items/' + parseInt(row['id']) + '" class="btn btn-primary btn-xs"><i class="fa fa-eye"></i></a> ' + editButton + deleteButton;
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                },

            ],
            pageLength: 10,
            lengthMenu: [
                [5, 10, 20],
                [5, 10, 20]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });
    });

    function deleteData(id) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/items/' + id,
                    dataType: "json",
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function(response) {
                        console.log('consode');
                        console.log(response);
                        if (response[0] == 1003) {
                            swalWithBootstrapButtons.fire(
                                'Deleted!',
                                response[1],
                                'success'
                            )
                        } else {
                            swalWithBootstrapButtons.fire(
                                'Failed!',
                                response[1],
                                'warning'
                            )

                        }
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error, response) {
                        swalWithBootstrapButtons.fire(
                            'Failed!',
                            'Failed to delete data. Please try again.',
                            'error'
                        )
                    }
                });
            }
        })
    }
</script>
@endsection