@extends('layouts.app')
@section('content')
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header" >
                        <div class="float-left">
                            <span class="card-title">Show Data</span>
                        </div>
                        <div class="float-right">
                            <a class="btn btn-sm btn-danger" href="{{ route('lot-process.index') }}"> Back</a>
                        </div>
                    </div>
                    <div class="card-body row">
                        <div class="form-group col-md-6">
                            <strong>Code:</strong>
                            <input type="text" class="form-control" value="{{$data->code}}" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <strong>Name</strong>
                            <input type="text" class="form-control" value="{{$data->name}}" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <strong>Create Who</strong>
                            <input type="text" class="form-control" value="{{ $data->created_who }}" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <strong>Updated Who</strong>
                            @if($data->updated_who == null)
                                <input type="text" class="form-control" value="Not updated" readonly>
                            @else
                                <input type="text" class="form-control" value="{{ $data->updated_who }}" readonly>
                            @endif
                        </div>
                        <div class="form-group col-md-6">
                            <strong>Created At</strong>
                            <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($data->created_at)->format('d-m-Y H:i:s') }}" readonly>
                        </div>
                        <div class="form-group col-md-6">
                            <strong>Updated At</strong>
                            @if($data->updated_at == null)
                                <input type="text" class="form-control" value="Not updated" readonly>
                            @else
                                <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($data->updated_at)->format('d-m-Y H:i:s') }}" readonly>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
