@extends('layouts.app')
@section('content')

<Style>
    .image-preview {
        max-width: 100px;
        max-height: 100px;
        margin-top: 10px;
    }
</Style>
<div class="content-header">
    <div class="row">
        @if ($message = Session::get('success'))
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
        @if ($message = Session::get('erorr'))
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
    </div>
</div>
<section class="content container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">{{ $datas['title'] }}</span>
                </div>
                <div class="card-body">
                    <form method="POST" id="myForm" action="{{ route('mapping.store') }}" role="form" enctype="multipart/form-data">
                        <?php if (isset($data->id)) { ?>
                            <input type="hidden" name="id" value="{{$data->id}}">
                        <?php }  ?>
                        @csrf
                        <div class="box box-info padding-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <!-- Destination ID Dropdown -->
                                    <div class="form-group">
                                        <label for="destination_id">Destination<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="destination_id" class="form-control{{ $errors->has('destination_id') ? ' is-invalid' : '' }} select2" required>
                                            <option value="">Select Destination</option>
                                            @foreach($datas['destinations'] as $destination)
                                            <option value="{{ $destination->id }}" {{ old('destination_id', $data->destination_id ?? '') == $destination->id ? 'selected' : '' }}>{{ $destination->code }}</option>
                                            @endforeach
                                        </select>
                                        {!! $errors->first('destination_id', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Lot Process ID Dropdown -->
                                    <div class="form-group">
                                        <label for="lot_process_id">Lot Process<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="lot_process_id" class="select2 form-control{{ $errors->has('lot_process_id') ? ' is-invalid' : '' }} select2" required>
                                            <option value="">Select Lot Process</option>
                                            @foreach($datas['lot_processes'] as $lot_process)
                                            <option value="{{ $lot_process->id }}" {{ old('lot_process_id', $data->lot_process_id ?? '') == $lot_process->id ? 'selected' : '' }}>{{ $lot_process->code }}</option>
                                            @endforeach
                                        </select>
                                        {!! $errors->first('lot_process_id', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <!-- Case ID Dropdown -->
                                    <div class="form-group">
                                        <label for="case_id">Case<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="case_id" class="form-control{{ $errors->has('case_id') ? ' is-invalid' : '' }} select2" required>
                                            <option value="">Select Case</option>
                                            @foreach($datas['cases'] as $case)
                                            <option value="{{ $case->id }}" {{ old('case_id', $data->case_id ?? '') == $case->id ? 'selected' : '' }}>{{ $case->code }}</option>
                                            @endforeach
                                        </select>
                                        {!! $errors->first('case_id', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <!--Start Date Field -->
                                    <div class="form-group">
                                        <label for="start_date">Start Date<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="date" name="start_date" class="form-control{{ $errors->has('start_date') ? ' is-invalid' : '' }}" value="{{ old('start_date', $data->start_date ?? '') }}" required>
                                        {!! $errors->first('start_date', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <!-- End Date Field -->
                                    <div class="form-group">
                                        <label for="end_date">End Date<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="date" name="end_date" class="form-control{{ $errors->has('end_date') ? ' is-invalid' : '' }}" value="{{ old('end_date', $data->end_date ?? '') }}" required>
                                        {!! $errors->first('end_date', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!-- Detail Section -->
                        <div class="card card-default">
                            <div class="card-header">
                                <span class="card-title">Mapping Details</span>
                            </div>
                            <div class="card-body">
                                <div id="detail-section">
                                    <!-- Detail Items -->
                                    <div class="detail-item">
                                        <div class="form-group">
                                            <table class="table table-bordered table-mapping-details">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" style="vertical-align: middle;"> UNIQUE / PART NUMBER</th>
                                                        <th colspan="3">
                                                            <select name="items_id" class="form-control item-dropdown select2">
                                                                <option value="">Select Unique / Part Number</option>
                                                                @foreach($datas['items'] as $item)
                                                                <option value="{{ $item->id }}">
                                                                    {{ $item->code }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </th>
                                                        <th style="vertical-align: middle;">
                                                            <button type="button" class="btn btn-danger btn-xs" onclick="fetchItemData(this)"><i class="fas fa-plus"></i> Add row</button>
                                                        </th>
                                                    </tr>
                                                    <tr>
                                                        <th width="8%">DELETE</th>
                                                        <th width="2%">SEQUENCE</th>
                                                        <th>UNIQUE NUMBER</th>
                                                        <th>PART NUMBER</th>
                                                        <th>ADDRESS</th>
                                                        <th>IMAGE</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    {{-- Check if $data is set, use it in edit mode --}}
                                                    @isset($data_details)
                                                    @foreach($data_details as $index => $detail)
                                                    <tr>
                                                        <td class="text-center"><button type="button" class="btn btn-danger remove-row-btn btn-xs"><i class="fas fa-minus"></i></button>
                                                        </td>
                                                        <td>
                                                            <input type="hidden" name="details[{{ $index }}][id]" class="form-control" value="{{ $detail->id ?? '' }}" required>
                                                            <input type="hidden" name="details[{{ $index }}][item_id]" class="form-control" value="{{ $detail->item_id ?? '' }}" required>
                                                            <input type="text" name="details[{{ $index }}][sequence]" class="form-control c-index hanya_angka" value="{{ $detail->sequence ?? '' }}" required>
                                                        </td>
                                                        <td><input type="text" name="details[{{ $index }}][code]" class="form-control" value="{{ $detail->code ?? '' }}" readonly></td>
                                                        <td><input type="text" name="details[{{ $index }}][name]" class="form-control" value="{{ $detail->name ?? '' }}" readonly></td>
                                                        <td><input type="text" name="details[{{ $index }}][address]" class="form-control" value="{{ $detail->address ?? '' }}" readonly></td>
                                                        {{-- <td><input type="file" name="details[{{ $index }}][image]" class="form-control"></td>--}}
                                                        <td>
                                                            @if($detail->image)
                                                            <img src="{{ asset($detail->image) }}" class="image-preview" alt="Image Preview">
                                                            @endif
                                                            <input type="file" name="details[{{ $index }}][image]" class="form-control" onchange="previewImage(this, {{ $index }})">
                                                            <img id="image-preview-{{ $index }}" class="image-preview" src="#" alt="Image Preview" style="display: none;">
                                                        </td>
                                                        @endforeach
                                                        @endisset
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="box-footer mt20">
                            <a class="btn btn-danger" href="{{ route('mapping.index') }}">Back</a>
                            <button type="submit" name="action" value="save_and_close" class="btn bg-primary" id="btnSave">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    var var_url_store = "<?= $datas['url_store'] ?>";
    var var_url_redirect = "<?= $datas['url_redirect'] ?>";

    document.addEventListener("DOMContentLoaded", function() {
        const myForm = document.getElementById("myForm");
        myForm.addEventListener("submit", function(event) {
            event.preventDefault();

            const btnSave = document.getElementById("btnSave");
            btnSave.innerHTML = "Processing...";
            btnSave.disabled = true;

            Swal.fire({
                title: 'Processing...',
                text: 'Please wait while your data is being saved.',
                allowOutsideClick: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });
            console.log('urlnya :' + var_url_store);
            let formData = new FormData(document.getElementById('myForm'));
            $.ajax({
                url: var_url_store,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                // url: var_url_store,
                // type: 'POST',
                dataType: "json",
                // encode: true,
                // data: $('#myForm').serialize(),
                success: function(response) {
                    // console.log(response);
                    // console.log(response[0]);
                    // return false;
                    if (response[0] == 1003) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: response[1],
                            showConfirmButton: true,
                        }).then(() => {
                            window.location.href = var_url_redirect;
                        });
                    } else {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Warning',
                            text: response[1],
                        });
                    }

                },
                error: function(xhr, status, error) {
                    console.log('ada error');
                    Swal.close();
                    if (xhr.status === 422) {
                        var validationErrors = xhr.responseJSON.errors;
                        var errorMessages = '';
                        $.each(validationErrors, function(field, messages) {
                            errorMessages += messages[0] + '<br>';
                        });
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorMessages,
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Failed to save data: ' + (xhr.responseJSON.message || error),
                        });
                    }
                },
                complete: function() {
                    btnSave.disabled = false;
                    btnSave.innerHTML = "Save";
                }
            });
        });
    });

    $(document).ready(function() {

        // Function to remove a row
        $(document).on('click', '.remove-row-btn', function() {
            $(this).closest('tr').remove();
        });

        $(document).on('change', '.c-index', function() {
            var rowCount = $('.table-mapping-details tbody tr').length
            this.value = $.trim(this.value.replace(/^0+/, ''));
            for (let idx = 0; idx < rowCount; idx++) {
                // alert($('input[name="details[' + idx + '][sequence]"]').val())
                // alert(this.name)
                // alert(this.value)
                if ((!this.name.includes(idx)) && this.value == $('input[name="details[' + idx + '][sequence]"]').val()) {
                    alert('sequence number is already in use');
                    this.value = '';
                    return false;
                }
            }
        });

        // Function to fetch item data (code and address)
        window.fetchItemData = function() {
            var itemId = $("select[name='items_id']").val();
            var rowCount = $('.table-mapping-details tbody tr').length;
            console.log('itemId : ' + itemId);
            console.log('rowCount : ' + rowCount);
            if (itemId) {
                for (let idx = 0; idx < rowCount; idx++) {
                    // alert(itemId) 
                    // alert($('input[name="details[' + idx + '][item_id]"]').val())
                    if (itemId == $('input[name="details[' + idx + '][item_id]"]').val()) {
                        alert('The part number has already been entered, please choose another one');
                        $("select[name='items_id']").val('').trigger('change')
                        return false;
                    }
                }

                $.ajax({
                    url: '/fetch-item-data/' + itemId,
                    type: 'GET',
                    success: function(response) {
                        if (response && response.id) {
                            console.log('sukses and log');
                            console.log(response);
                            var rowHTML = '<tr>';
                            rowHTML += '<td class="text-center"><button type="button" class="btn btn-danger remove-row-btn btn-xs"><i class="fas fa-minus"></i></button></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][sequence]" class="form-control c-index hanya_angka" value="' + (rowCount + 1) + '" required></td>';
                            rowHTML += '<td style="display:none"><input type="text" name="details[' + rowCount + '][item_id]" class="form-control" readonly value="' + response.id + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][code]" class="form-control" readonly value="' + response.code + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][name]" class="form-control" readonly value="' + response.name + '"></td>';
                            rowHTML += '<td><input type="text" name="details[' + rowCount + '][address]" class="form-control" readonly value="' + response.address + '"></td>';
                            // rowHTML += '<td><input type="file" name="details[' + rowCount + '][image]" class="form-control"></td>';
                            rowHTML += '<td><input type="file" name="details[' + rowCount + '][image]" class="form-control" onchange="previewImage(this, ' + rowCount + ')"><img id="image-preview-' + rowCount + '" class="image-preview" src="#" alt="Image Preview" style="display: none;"></td>';
                            rowHTML += '</tr>';
                            $('.table-mapping-details tbody').append(rowHTML);
                            $("select[name='items_id']").val('').trigger('change')
                        }
                    }
                });
            } else {
                alert('Please select Part Number');
                $("select[name='items_id']").focus();
            }
        };

        window.previewImage = function(input, index) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $('#image-preview-' + index).attr('src', e.target.result).show();
                }

                reader.readAsDataURL(input.files[0]);
            }
        };

    });
</script>
@endsection