@extends('layouts.app')

@section('content')
<section class="content container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="m-0">Detail Mapping</h5>
                        <a class="btn btn-sm btn-danger" href="{{ route('mapping.index') }}">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <strong>Destination:</strong>
                                </div>
                                <div class="col-md-8">
                                    {{ $data->destination->code ?? 'Not available' }}
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <strong>Lot Process:</strong>
                                </div>
                                <div class="col-md-8">
                                    {{ $data->LotProcess->code ?? 'Not available' }}
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-4">
                                    <strong>Case:</strong>
                                </div>
                                <div class="col-md-8">
                                    {{ $data->mappingCase->code ?? 'Not available' }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detail Section -->
                    <div class="card card-default mt-4">
                        <div class="card-header">
                            <h5 class="card-title">Mapping Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>PART NO</th>
                                            <th>UNIQUE NUMBER</th>
                                            <th>ADDRESS</th>
                                            <th>IMAGE</th>
                                            <th>SEQUENCE</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data->details as $detail)
                                        <tr>
                                            <td>{{ $detail->item->name }}</td>
                                            <td>{{ $detail->item->code }}</td>
                                            <td>{{ $detail->item->address }}</td>
                                            <td>
                                                @if ($detail->image)
                                                <a href="#" class="view-image" data-toggle="modal" data-target="#imageModal-{{ $detail->id }}">
                                                    <img src="{{ asset($detail->image) }}" class="img-fluid" style="max-width: 200px;">
                                                </a>
                                                <!-- Modal -->
                                                <div class="modal fade" id="imageModal-{{ $detail->id }}" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel-{{ $detail->id }}" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="imageModalLabel-{{ $detail->id }}">Image Preview
                                                                </h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <img src="{{ asset($detail->image) }}" class="img-fluid">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @else
                                                No image available
                                                @endif
                                            </td>
                                            <td>{{ $detail->sequence }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        $('.view-image').click(function(e) {
            e.preventDefault();
            var target = $(this).attr('data-target');
            $(target).modal('show');
        });
    });
</script>
@endpush