@extends('layouts.app')
@section('content')
    <div class="content-header">

        <div class="row">
            @if ($message = Session::get('success'))
                <div class="col-md-12">
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ $message }}
                    </div>
                </div>
            @endif
            @if ($message = Session::get('erorr'))
                <div class="col-md-12">
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {{ $message }}
                    </div>
                </div>
            @endif
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="uploadForm" action="{{ route('mapping.import') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="file">Choose Excel File:</label>
                                    <input type="file" class="form-control-file" id="file" name="file" required accept=".xlsx, .xls">
                                </div>
                                <a class="btn btn-danger " href="{{ route('mapping.index') }}"> Back</a>
                                <button type="button" id="btn-upload" class="btn btn-primary">Upload</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
        $(document).ready(function () {
            $('#btn-upload').click(function () {
                var formData = new FormData($('#uploadForm')[0]);

                $.ajax({
                    url: "{{ route('mapping.import') }}",
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    beforeSend: function () {
                        Swal.fire({
                            title: 'Uploading...',
                            allowOutsideClick: false,
                            onBeforeOpen: () => {
                                Swal.showLoading();
                            }
                        });
                    },
                    success: function (response) {
                        Swal.fire({
                            title: response.errorCount > 0 ? 'Upload Partially Successful!' : 'Upload Successful!',
                            text: `Total Successful: ${response.successCount}\nTotal Errors: ${response.errorCount}`,
                            icon: response.errorCount > 0 ? 'warning' : 'success'
                        }).then(() => {
                            if (response.errorCount > 0) {
                                // Download error file
                                window.location.href = response.downloadUrl;
                            } else {
                                window.location.href = "{{ route('mapping.index') }}";
                            }
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            title: 'Error!',
                            text: 'Error uploading file: ' + xhr.responseJSON.error,
                            icon: 'error'
                        }).then(() => {
                            // Actions if an error occurs during upload
                        });
                    }
                });
            });
        });
    </script>
@endsection
