@extends('layouts.app')


@section('css')
    <link rel="stylesheet" href="/assets/plugins/summernote/summernote-bs4.css">
@endsection
@section('content')
    <section class="content container-fluid">
        <div class="row">
            <div class="col-md-12">

                @includeif('partials.errors')

                <div class="card card-default">
                    <div class="card-header " style="background-color: #632b8d; color:white;">
                        <span class="card-title ">Ubah Konfigurasi</span>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('masterConfig.update', $masterConfig->id) }}"  role="form" enctype="multipart/form-data">
                            {{ method_field('PATCH') }}
                            @csrf
                            <div class="box box-info padding-1">
                                <div class="box-body row">
                                    <div class="form-group col-md-6">
                                        {{ Form::label('key') }}
                                        {{ Form::text('key', $masterConfig->key, ['class' => 'form-control' . ($errors->has('key') ? ' is-invalid' : ''),'readonly']) }}
                                        {!! $errors->first('key', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                    <div class="form-group col-md-6">
                                        {{ Form::label('description') }}
                                        {{ Form::text('description', $masterConfig->description, ['class' => 'form-control' . ($errors->has('description') ? ' is-invalid' : ''), 'readonly']) }}
                                        <span class=""></span>
                                        {!! $errors->first('description', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                    <div class="form-group col-md-6">
                                        {{ Form::label('value') }}
                                        {{ Form::text('value', $masterConfig->value, ['class' => 'form-control' . ($errors->has('value') ? ' is-invalid' : ''), 'required']) }}
                                        <span class=""></span>
                                        {!! $errors->first('value', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>

                                </div>
                                <div class="box-footer mt20">
                                    <button type="submit" name="action" value="save"
                                            class="btn bg-purple">Simpan</button>
                                    <a class="btn btn-danger float-right" href="{{ route('masterConfig.index') }}"> Kembali</a>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')

    <script src="/assets/plugins/summernote/summernote-bs4.min.js"></script>
    <!-- Page Script -->

@endsection


