@extends('layouts/app')


@section('content')
<div class="content">
    <div class="container-fluit">
        @if (session('status'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4>Info!</h4>
            {{ session('status') }}
        </div>
        @endif
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Permission</h3>
                        <div class="card-tools">
                            @if (auth()->user()->can('create-permission'))
                            <button type="button" class="btn btn-primary btn-xs" data-toggle="modal" data-target="#modal-default">
                                <i class="fas fa-plus"></i>
                                Add
                            </button>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="list-data" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="1%">NO</th>
                                        <th>PERMISSION</th>
                                        <th>GROUP PERMISSION</th>
                                        <th class="text-center">ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-default">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Permission</h4>
            </div>
            <form action="{{ url('/permission') }}" method="post">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="exampleInputEmail1">Permission<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                        <input type="text" class="form-control" name="permission" required>
                    </div>
                    <div class="form-group">
                        <label>Group Permission<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                        <input type="text" class="form-control" name="permission_grub">
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Permission</h4>
            </div>
            <form action="#" method="post" id="editform">
                @csrf
                <input type="hidden" name="_method" value="PUT">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="exampleInputEmail1">Permission<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                        <input type="text" class="form-control" name="permission" id="permission" required>
                    </div>
                    <div class="form-group">
                        <label for="">Group Permission<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                        <input type="text" class="form-control" name="permission_grub" id="permission_grub">
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Closed</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-exel">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Pilih Export Excel</h4>
            </div>
            a
        </div>
    </div>
</div>
</div>

<script>
    var access = @json($access);
    var authUserCanEdit = access.canEdit;
    var authUserCanDelete = access.canDelete;
    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            // language: {
            //     url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
            // },
            order: [
                [0, "desc"]
            ],
            ajax: '/list-data-permission',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'permission_grub',
                    name: 'permission_grub'
                },
                {
                    render: function(data, type, row) {
                        var editButton = authUserCanEdit ? '<button type="button" onclick="editdata(' + row['id'] + ')" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></button>' : '';
                        var deleteButton = authUserCanDelete ? '<button class="btn btn-danger btn-xs" onclick="hapusdata(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                        return editButton + ' ' + deleteButton;
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                }
            ],
            pageLength: 20,
            lengthMenu: [
                [20, 50, 100, 500],
                [20, 50, 100, 500]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });

    });

    //=====================================================================================================
    function editdata(kode) {
        $.ajax({
            type: 'GET',
            url: '/permission/' + kode + '/edit',
            success: function(data) {
                $.each(data, function(key, value) {
                    $('#editform').attr('action', '/permission/' + value.id);
                    $('#permission').val(value.name);
                    $('#permission_grub').val(value.permission_grub);
                });
                $('#modal-edit').modal('show');
            },
            complete: function() {},
            error: function() {
                swalWithBootstrapButtons.fire(
                    'Oops!',
                    'Edit Failed',
                    'error'
                )
            }
        });
    }

    //=====================================================================================================
    function hapusdata(kode) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes!',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/permission/' + kode,
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function() {
                        swalWithBootstrapButtons.fire(
                            'Deleted!',
                            'Deleted successfully.',
                            'success'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function() {
                        swalWithBootstrapButtons.fire(
                            'Oops!',
                            'Deleted Failed',
                            'error'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    }
                });
            }
        })
    }
</script>
@endsection