@extends('layouts/app')

@section('content')
<div class="content">
    <div class="container-fluit">
        @if (session('status'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h4>Info!</h4>
            {{ session('status') }}
        </div>
        @endif
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header ">
                        <h3 class="card-title">Roles</h3>
                        <div class="card-tools">
                            @if(auth()->user()->can('create-roles'))
                            <a href="{{ url('/roles/create') }}">
                                <button type="button" class="btn btn-primary btn-xs"><i class="fas fa-plus"></i> Add
                                </button>
                            </a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="list-data" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="1%">NO</th>
                                        <th>ROLE</th>
                                        <th>PERMISSION</th>
                                        <th class="text-center">ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</div>
<script>
    var access = @json($access);
    var authUserCanEdit = access.canEdit;
    var authUserCanDelete = access.canDelete;

    $(function() {
        $('#list-data').DataTable({
            processing: true,
            serverSide: true,
            order: [
                [0, "desc"]
            ],
            ajax: '/list-data-roles',
            columns: [{
                    data: 'id',
                    render: function(data, type, row, meta) {
                        return meta.row + meta.settings._iDisplayStart + 1;
                    }
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    render: function(data, type, row) {
                        return row['total'] + ' Permission'
                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": 'total',
                },
                {
                    render: function(data, type, row) {
                        if (row['id'] != 1) {
                            var editButton = authUserCanEdit ? '<a href="/roles/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></a>' : '';
                            var deleteButton = authUserCanDelete ? ' <button class="btn btn-danger btn-xs" onclick="hapusdata(' + row['id'] + ')"><i class="fa fa-trash"></i></button>' : '';
                            return editButton + ' ' + deleteButton;
                        } else {
                            var editButton = authUserCanEdit ? '<a href="/roles/' + row['id'] + '/edit" class="btn btn-success btn-xs"><i class="fa fa-wrench"></i></a>' : '';
                            return editButton;
                        }

                    },
                    "className": 'text-center',
                    "orderable": false,
                    "data": null,
                },
            ],
            pageLength: 10,
            lengthMenu: [
                [5, 10, 20],
                [5, 10, 20]
            ],
            // Responsive settings
            responsive: true,
            autoWidth: false
        });

    });

    function hapusdata(kode) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: 'btn btn-success',
                cancelButton: 'btn btn-danger'
            },
            buttonsStyling: true
        })
        swalWithBootstrapButtons.fire({
            title: 'Are you sure you want to delete this data?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes!',
            cancelButtonText: 'No',
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'DELETE',
                    url: '/roles/' + kode,
                    data: {
                        '_token': $('input[name=_token]').val(),
                    },
                    success: function(response) {
                        swalWithBootstrapButtons.fire(
                            'Deleted!',
                            response.message,
                            'success'
                        )
                        $('#list-data').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error, response) {
                        swalWithBootstrapButtons.fire(
                            'Oops!',
                            'Deleted Failed',
                            'error'
                        )
                    }
                });
            }
        })
    }
</script>
@endsection