@extends('layouts.app')
@section('content')
<div class="content-header">
    <div class="row">
        @if ($message = Session::get('success'))
        <div class="col-md-12">
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
        @if ($message = Session::get('error'))
        <div class="col-md-12">
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                {{ $message }}
            </div>
        </div>
        @endif
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span id="card_title">
                            Schedule Synchronize
                        </span>

                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <div class="form-group">
                            <table class="table table-bordered add-remove-table" id="schedule-sync-table">
                                <thead>
                                    <tr>
                                        <th style="width: 5%">
                                            <button type="button" class="btn btn-primary btn-xs add-row-btn" data-toggle="modal" data-target="#modal-default">
                                                <i class="fas fa-plus"></i>
                                            </button>
                                        </th>
                                        <th>TIME SYNCHRONIZE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add Time Synchronize</h4>
                </div>
                <form id="add-time-sync-form" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="time_sync">Time Synchronize<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                            <input type="time" class="form-control" name="time_sync" id="time_sync" required>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            var table = $('#schedule-sync-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('schedule-sync.listdata') }}",
                columns: [{
                        data: null,
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'time_sync',
                        name: 'time_sync'
                    }
                ],
                columnDefs: [{
                    targets: 0,
                    render: function(data, type, row, meta) {
                        return '<button type="button" class="btn btn-danger btn-xs remove-row-btn"><i class="fas fa-minus"></i></button>';
                    }
                }]
            });

            // Event listener for form submission
            $('#add-time-sync-form').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                $.ajax({
                    url: "{{ route('schedule-sync.store') }}",
                    method: "POST",
                    data: $(this).serialize(), // Serialize form data
                    success: function(response) {
                        if (response.success) {
                            Swal.fire('Success!', 'Data has been added successfully', 'success');
                            table.ajax.reload();
                            $('#modal-default').modal('hide'); // Hide modal after successful submission
                        } else {
                            Swal.fire('Failed!', 'An error occurred while adding data', 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Failed!', 'An error occurred while adding data', 'error');
                    }
                });
            });

            // Event listener for remove button 
            $(document).ready(function () {
                $('#schedule-sync-table').on('click', '.remove-row-btn', function () {
                    var row = table.row($(this).parents('tr'));
                    var rowData = row.data();
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "This data will be deleted!",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Yes, delete!',
                        cancelButtonText: 'No, cancel'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $.ajax({
                                url: "{{ route('schedule-sync.destroy', '') }}/" + rowData.id,
                                method: "DELETE",
                                data: {
                                    _token: "{{ csrf_token() }}"
                                },
                                success: function (response) {
                                    if (response.success) {
                                        Swal.fire('Success!', 'Data has been deleted successfully', 'success');
                                        row.remove().draw();
                                    } else {
                                        Swal.fire('Failed!', 'An error occurred while deleting data', 'error');
                                    }
                                },
                                error: function () {
                                    Swal.fire('Failed!', 'An error occurred while deleting data', 'error');
                                }
                            });
                        } else {
                            console.log('Deletion cancelled');
                        }
                    });
                });
            });
        });
    </script>
</section>
@endsection