@extends('layouts/app')

@section('content')
<div class="content">
    <div class="container-fluit">
        <div class="row">
            <div class="col-12">
                <div class="card ">
                    <div class="card-header">
                        <h3 class="card-title">Add User</h3>
                    </div>
                    <form method="POST" onsubmit="return validasiinput();" role="form" enctype="multipart/form-data" action="{{ url('/users') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Username<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="text" class="form-control {{$errors->has('username') ? ' is-invalid' : ''}}" name="username" required autofocus>
                                        {!! $errors->first('username', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Name<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="text" class="form-control {{$errors->has('nama') ? ' is-invalid' : ''}}" name="nama" required>
                                        {!! $errors->first('nama', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Email<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="email" class="form-control {{$errors->has('email') ? ' is-invalid' : ''}}" name="email" required>
                                        {!! $errors->first('email', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Level<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <select name="level" class="form-control {{$errors->has('level') ? ' is-invalid' : ''}} select2">
                                            @foreach ($roles as $row_roles)
                                            <option value="{{ $row_roles->id }}-{{ $row_roles->name }}">
                                                {{ $row_roles->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                        {!! $errors->first('level', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Password<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="password" class="form-control {{$errors->has('userpassword') ? ' is-invalid' : ''}}" id="password" name="userpassword" autocomplete="new-password" required>
                                        {!! $errors->first('userpassword', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Confirmation Password<sup style="font-size: 1.5em; vertical-align: text-bottom;">*</sup></label>
                                        <input type="password" class="form-control {{$errors->has('kpassword') ? ' is-invalid' : ''}}" id="kpassword" name="kpassword" required>
                                        {!! $errors->first('kpassword', '<div class="invalid-feedback">:message</div>') !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" onclick="history.go(-1)" class="btn btn-danger">Cancel</button>
                            <button type="submit" class="btn btn-primary float-right">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function validasiinput() {
        if ($('#password').val() == $('#kpassword').val()) {
            return true;
        } else {
            Swal.fire({
                title: 'Sorry',
                text: 'Confirm the wrong password!'
            })
            $('#kpassword').val('');
            return false;
        }
    }
</script>
@endsection